/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.codegen.templates;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.codegen.CGAncillaries;
import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.CallbackType;
import pt.digitalis.dif.dem.annotations.parameter.CustomParameters;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.EventType;
import pt.digitalis.dif.dem.objects.LicenseEditionType;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.ViewType;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.dem.objects.parameters.IParameters;
import pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors;
import pt.digitalis.dif.dem.objects.parameters.rules.IParameterRule;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;
import pt.digitalis.dif.exception.objects.ParameterException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.startup.DIFGeneralConfigurationParameters;

/**
 * This class is a template for the IStageInstance interface method implementations. The CodeGen will copy these methods
 * to a new Instance class for each stage. Some methods will be copied "as is", others will be tweaked.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/07/12
 */
public class StageInstanceCGTemplate implements IStageInstance {

    /** The errors of the parameter processing */
    private ControllerException _CG_authenticationException;

    /** The execution context. */
    private IDIFContext _CG_context;

    /** T if the stage jas an annotated {@link CustomParameters} method */
    private boolean _CG_hasCustomParameters = false;

    /** The errors of the parameter processing */
    private ParameterErrors _CG_parameterErrors;

    /** The parameters object */
    private IParameters _CG_parameters;

    /** the _CG_proxy instance */
    private IStage _CG_proxy;

    /** the active/present features */
    private List<String> activeStageFeatures = null;

    /** T if the stage has already been initialized by calling the "_CG_init" method */
    private boolean isInitialized;

    /**
     * a private instance of template resources. Used for optimizations and live debug purposes instead of direct code
     * in this template that would not be as easily debuged or fast compiled in run time
     */
    private TemplateResources templateResources = null;

    /**
     * This method will be used by the code gen module to set the annotated attributes.
     * 
     * @param difContext
     *            the context
     */
    public void __Stage__InjectedAttributesInitMethod__(IDIFContext difContext)
    {}

    /**
     * This method will be used by the framework to do some post processing work.
     * 
     * @param difContext
     *            the context
     */
    public void __Stage__PostProcessingMethod__(IDIFContext difContext)
    {}

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_execute(IDIFContext)
     */
    public ViewObject _CG_execute(IDIFContext context) throws BusinessFlowException
    {
        return this.getTemplateResources().stageExecute(this, context);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_finalize(IDIFContext)
     */
    public boolean _CG_finalize(IDIFContext context) throws BusinessFlowException
    {
        // Post process parameters
        __Stage__PostProcessingMethod__(context);

        // Call the wrapper to the user defined method
        return callFinalizeMethod(context);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#_CG_init(IDIFContext)
     */
    public boolean _CG_init(IDIFContext context) throws BusinessFlowException
    {
        // If needed inject IoC contributions
        if (this.hasInjectedContributions())
            DIFIoCRegistry.getRegistry().injectDependencies(this);

        // Init context
        this.setContext(context);

        // Initialize an empty parameter error report
        this._CG_parameterErrors = new ParameterErrors(this);

        // Initialize injected attributes
        this.__Stage__InjectedAttributesInitMethod__(context);

        // Refresh remaining parameters (created by the CustomParameters annotation)
        try
        {
            this._CG_parameterErrors.refreshParameters(this);
        }
        catch (ParameterException e)
        {
            throw new BusinessFlowException(e, context);
        }

        // Is called prior to the business stage init method since this initialization is the DIF internal
        // initialization process. Not dependent of the business initialization
        this.isInitialized = true;

        // Call the wrapper to the user defined method
        return callInitMethod(context);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *      pt.digitalis.dif.dem.objects.EventType, java.lang.String)
     */
    public Object callEventMethod(IDIFContext context, EventType type, String eventName)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_OBJECT;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteMethod(pt.digitalis.dif.controller.interfaces.IDIFContext)
     */
    public ViewObject callExecuteMethod(IDIFContext context)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#callExecuteOnEventMethod(pt.digitalis.dif.controller.interfaces.IDIFContext,
     *      pt.digitalis.dif.dem.objects.EventType, java.lang.String)
     */
    public ViewObject callExecuteOnEventMethod(IDIFContext context, EventType type, String eventName)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_VIEW;
    }

    /**
     * The method that will be enhanced with the call to the method annotated with <code>@Finalize</code>.
     * 
     * @param context
     *            the execution context
     * @return as defined on the user-defined <code>@Finalize</code>-annotated method
     */
    protected boolean callFinalizeMethod(IDIFContext context)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_BOOLEAN;
    }

    /**
     * The method that will be enhanced with the users custom parameters (call to the method annotated with
     * <code>@CustomParameters</code>.
     * 
     * @param parameters
     *            the stage parameters to be customized
     */
    protected void callInitCustomParametersMethod(IParameters parameters)
    {}

    /**
     * The method that will be enhanced with the call to the method annotated with <code>@DIFInitializer</code>.
     * 
     * @param context
     *            the execution context
     * @return as defined on the user-defined <code>@DIFInitializer</code>-annotated method
     */
    protected boolean callInitMethod(IDIFContext context)
    {
        return CGAncillaries.CG_TO_BE_IMPLEMENTED_BOOLEAN;
    }

    /**
     * Creates a new view object. For usage of the CG methods
     * 
     * @param engine
     *            the engine of the view
     * @param type
     *            the type of the view
     * @param target
     *            the target resource/template of the view
     * @param isDefault
     *            T if the view is the default view
     * @return the created view object
     */
    protected ViewObject createView(String engine, String type, String target, boolean isDefault)
    {
        return new ViewObject(engine, ViewType.valueOf(type), target, isDefault);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#declareFeatureActive(java.lang.String)
     */
    public void declareFeatureActive(String featureID)
    {
        this.getActiveStageFeatures().add(featureID);
    }

    /**
     * Inspector for the 'activeStageFeatures' attribute.
     * 
     * @return the activeStageFeatures value
     */
    private List<String> getActiveStageFeatures()
    {
        if (this.activeStageFeatures == null)
            this.activeStageFeatures = new ArrayList<String>();

        return this.activeStageFeatures;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getAuthenticationError()
     */
    public ControllerException getAuthenticationError()
    {
        return _CG_authenticationException;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICallback#getCallbackType()
     */
    public CallbackType getCallbackType()
    {
        return _CG_proxy.getCallbackType();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getContext()
     */
    public IDIFContext getContext()
    {
        return this._CG_context;
    }

    /**
     * The default error stage is constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the default error stage fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorStage()
     */
    public IStage getDefaultErrorStage()
    {
        return this._CG_proxy.getDefaultErrorStage();
    }

    /**
     * The default error view is constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the default error view fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultErrorView()
     */
    public ViewObject getDefaultErrorView()
    {
        return this._CG_proxy.getDefaultErrorView();
    }

    /**
     * The default view is constant and common to all instances and as such can be placed on the _CG_proxy. This method
     * simply delegates the default view fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getDefaultView()
     */
    public ViewObject getDefaultView()
    {
        return this._CG_proxy.getDefaultView();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getEventHandlers()
     */
    public Map<EventType, List<String>> getEventHandlers()
    {
        return _CG_proxy.getEventHandlers();
    }

    /**
     * The ID is constant and common to all instances and as such can be placed on the _CG_proxy. This method simply
     * delegates the ID fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getID()
     */
    public String getID()
    {
        return _CG_proxy.getID();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorStages()
     */
    public Map<String, String> getInjectedErrorStages()
    {
        return _CG_proxy.getInjectedErrorStages();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInjectedErrorViews()
     */
    public Map<String, ViewObject> getInjectedErrorViews()
    {
        return _CG_proxy.getInjectedErrorViews();
    }

    /**
     * The injected stages are constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the injected stages fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedStages()
     */
    public List<String> getInjectedStages()
    {
        return this._CG_proxy.getInjectedStages();
    }

    /**
     * The injected views are constant and common to all instances and as such can be placed on the _CG_proxy. This
     * method simply delegates the injected views fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getInjectedViews()
     */
    public List<ViewObject> getInjectedViews()
    {
        return _CG_proxy.getInjectedViews();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getInstance()
     */
    public IStageInstance getInstance()
    {
        return this;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#getLicenseEdition()
     */
    public LicenseEditionType getLicenseEdition()
    {
        return TemplateResources.getRegistrationManager().getStageEdition(this.getID());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessage(java.lang.String)
     */
    public String getMessage(String messageID)
    {
        return this.getMessages().get(messageID);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessageForLanguage(java.lang.String, java.lang.String)
     */
    public String getMessageForLanguage(String language, String messageID)
    {
        return _CG_proxy.getMessageForLanguage(language, messageID);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IMessage#getMessages()
     */
    public Map<String, String> getMessages()
    {
        if (getContext() == null || getContext().getSession() == null)
            return _CG_proxy.getMessagesForLanguage(DIFGeneralConfigurationParameters.getInstance()
                    .getDefaultLanguage());
        else
            return _CG_proxy.getMessagesForLanguage(getContext().getSession().getLanguage());
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getMessagesForLanguage(java.lang.String)
     */
    public Map<String, String> getMessagesForLanguage(String language)
    {
        return _CG_proxy.getMessagesForLanguage(language);
    }

    /**
     * The name is constant and common to all instances and as such can be placed on the _CG_proxy. This method simply
     * delegates the name fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getName()
     */
    public String getName()
    {
        return _CG_proxy.getName();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getOriginalClassName()
     */
    public String getOriginalClassName()
    {
        return _CG_proxy.getOriginalClassName();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getOverridesStageID()
     */
    public String getOverridesStageID()
    {
        return _CG_proxy.getOverridesStageID();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getParameterErrors()
     */
    public ParameterErrors getParameterErrors()
    {
        return _CG_parameterErrors;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getParameters()
     */
    @SuppressWarnings("static-access")
    public IParameters getParameters()
    {
        if (_CG_parameters == null)
        {
            _CG_parameters = getTemplateResources().getParametersInstance(this);
            this.callInitCustomParametersMethod(_CG_parameters);

            if (_CG_hasCustomParameters)
            {
                // Process rule dependencies, after custom rule definition
                try
                {
                    for (IParameter<?> parameter: _CG_parameters.getStageParameters().getParameters().values())
                    {
                        for (IParameterRule<?> rule: parameter.getRules())
                        {
                            for (String parameterDependID: rule.getParameters())
                            {
                                IParameter<?> parameterDepend = _CG_parameters.getStageParameters().getParameters()
                                        .get(parameterDependID);

                                if (parameterDepend != null
                                        && !parameterDepend.isReferencedInARuleFromAnotherParameter())
                                    parameterDepend.setReferencedInARuleFromAnotherParameter(true);
                            }
                        }
                    }
                }
                catch (ParameterException e)
                {
                    e.printStackTrace();
                }
            }
        }

        return _CG_parameters;
    }

    /**
     * The service is constant and common to all instances and as such can be placed on the _CG_proxy. This method
     * simply delegates the service fetching to the _CG_proxy.
     * 
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#getService()
     */
    public IService getService()
    {
        return this._CG_proxy.getService();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#getStageInstanceClassName()
     */
    public String getStageInstanceClassName()
    {
        return _CG_proxy.getStageInstanceClassName();
    }

    /**
     * For usage of the CG methods
     * 
     * @return an instance of template resources
     */
    protected TemplateResources getTemplateResources()
    {
        if (this.templateResources == null)
            this.templateResources = TemplateResources.getInstance();

        return templateResources;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IEntity#getUID()
     */
    public String getUID()
    {
        return _CG_proxy.getUID();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#hasAuthentication()
     */
    public boolean hasAuthentication()
    {
        return _CG_proxy.hasAuthentication();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthenticationErrorInjection()
     */
    public boolean hasAuthenticationErrorInjection()
    {
        return _CG_proxy.hasAuthenticationErrorInjection();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasAuthorization()
     */
    public boolean hasAuthorization()
    {
        return _CG_proxy.hasAuthorization();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICallback#hasCallbackEnabled()
     */
    public boolean hasCallbackEnabled()
    {
        return _CG_proxy.hasCallbackEnabled();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasInjectedContributions()
     */
    public boolean hasInjectedContributions()
    {
        return _CG_proxy.hasInjectedContributions();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasParameterErrorInjection()
     */
    public boolean hasParameterErrorInjection()
    {
        return _CG_proxy.hasParameterErrorInjection();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStage#hasValidationLogicForForm(java.lang.String)
     */
    public boolean hasValidationLogicForForm(String formName)
    {
        return this._CG_proxy.hasValidationLogicForForm(formName);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#isFeatureEnabled(java.lang.String)
     */
    public boolean isFeatureEnabled(String featureID)
    {
        return this.getActiveStageFeatures().contains(featureID);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#isInitialized()
     */
    public boolean isInitialized()
    {
        return this.isInitialized;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistered()
     */
    public boolean isRegistered()
    {
        return _CG_proxy.isRegistered();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#isRegistrable()
     */
    public boolean isRegistrable()
    {
        return _CG_proxy.isRegistrable();
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#register(java.lang.String, java.lang.String)
     */
    public boolean register(String name, String key)
    {
        return _CG_proxy.register(name, key);
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setAuthenticationError(pt.digitalis.dif.exception.controller.ControllerException)
     */
    public void setAuthenticationError(ControllerException exception)
    {
        this._CG_authenticationException = exception;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setContext(IDIFContext)
     */
    public void setContext(IDIFContext newContext)
    {
        this._CG_context = newContext;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setParameterErrors(pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors)
     */
    public void setParameterErrors(ParameterErrors errors)
    {
        _CG_parameterErrors = errors;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IStageInstance#setProxy(pt.digitalis.dif.dem.interfaces.IStage)
     */
    public void setProxy(IStage _CG_proxy)
    {
        this._CG_proxy = _CG_proxy;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.IRegistrable#unregister()
     */
    public void unregister()
    {
        this._CG_proxy.unregister();

    }
}