/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.interfaces;

import java.util.Map;

import pt.digitalis.dif.controller.objects.DIFUserInSession;

/**
 * Defines a public accessible DIF Session
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 29, 2007
 */
public interface IDIFSession {

    /**
     * Stores a new attribute in the session.
     * 
     * @param key
     *            the key of the attribute
     * @param value
     *            the value of the new attribute
     */
    public void addAttribute(String key, Object value);

    /**
     * Stores a new attribute in the session.
     * 
     * @param key
     *            the key of the attribute
     * @return T if the attribute for the given key exists
     */
    public boolean containsAttribute(String key);

    /**
     * Retrieves a given attributes by id.
     * 
     * @param key
     *            the key of the attribute
     * @return the attribute value
     */
    public Object getAttribute(String key);

    /**
     * Retrieves all session attributes.
     * 
     * @return the session attributes Map
     */
    public Map<String, Object> getAttributes();

    /**
     * @return the language
     */
    public String getLanguage();

    /**
     * Provides the current session navigation history objet
     * 
     * @return the navigation history object in session
     */
    public INavigationHistory getNavigationHistory();

    /**
     * @return the sessionID
     */
    public String getSessionID();

    /**
     * Inspector for the session time-out value.
     * 
     * @return the session time-out value
     */
    public long getSessionTimeOut();

    /**
     * Gets the user in session.
     * 
     * @return the user in session
     */
    public DIFUserInSession getUser();

    /**
     * Checks if session has timed out.
     * 
     * @return T if session has timed out, F otherwise
     */
    public boolean hasTimedOut();

    /**
     * Checks if the session has a logged user
     * 
     * @return T if if is logged
     */
    public boolean isLogged();

    /**
     * @return T if the session has been marked for removal
     */
    public boolean isMarkedForRemoval();

    /**
     * Sets all session attributes.
     * 
     * @param attributes
     *            the session attributes to set
     */
    public void setAttributes(Map<String, Object> attributes);

    /**
     * @param language
     *            the language to set
     */
    public void setLanguage(String language);

    /**
     * Sets the session time-out value.
     * 
     * @param sessionTimeOut
     *            the session time out new value to set
     */
    public void setSessionTimeOut(long sessionTimeOut);

    /**
     * Sets the user in session.
     * 
     * @param user
     *            the user to set
     */
    public void setUser(DIFUserInSession user);
}
