package pt.digitalis.dif.controller.sanitycheck;

import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 30 de Ago de 2011
 */
public class GeneralCheckUp implements ISanityCheckTestSuite {

    /**
     * Test the JVM Encoding
     * 
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult testJavaEncoding()
    {
        TestResult result = new TestResult(ExecutionResult.FAILED);

        String encoding = (String) System.getProperties().get("file.encoding");

        if ("ISO-8859-1".equalsIgnoreCase(encoding))
        {
            result = new TestResult(ExecutionResult.PASSED);
        }
        else
        {
            result.setErrorMessage("The application must run on a JVM configured with the encoding 'ISO-8859-1'! Use the '-Dfile.encoding=ISO-8859-1' property to initialize the JVM.");
        }

        return result;
    }

    /**
     * Test the Java Version
     * 
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult testJavaVersion()
    {
        TestResult result = new TestResult(ExecutionResult.FAILED);

        String javaVersion = System.getProperty("java.version");

        Integer patch = 0;
        String[] split = javaVersion.split("_");

        if (split.length > 1)
        {
            patch = Integer.valueOf(split[1]);
        }

        if (javaVersion.contains("1.5.0") && patch >= 51)
        {
            result = new TestResult(ExecutionResult.PASSED);
        }
        else
        {
            result.setErrorMessage("The application must run on Version 1.5.0 with the patch 51, of the Java 2 Platform Standard Edition!");
        }

        return result;
    }

}
