/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem;

/**
 * Defines the available callback types.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/11/05
 */
public enum CallbackType {
    /** Callback disabled. */
    OFF,
    /** Keeps stage information including parameters passed only for future redirection */
    SAVE_PARAMETERS,
    /** Keeps session information so it will be possible to return to the Stage later. */
    SAVE_SESSION,
    /** Keeps stage information only for future redirection */
    SIMPLE;

    /**
     * Constructor by name
     * 
     * @param name
     *            the name of the callback
     * @return the corresponding callback type
     */
    static public CallbackType getCallbackTypeByName(String name)
    {
        if ("SAVE_SESSION".equalsIgnoreCase(name))
            return SAVE_SESSION;
        if ("SIMPLE".equalsIgnoreCase(name))
            return SIMPLE;
        if ("SAVE_PARAMETERS".equalsIgnoreCase(name))
            return SAVE_PARAMETERS;
        else
            return OFF;
    }
}