/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.codegen.util.DEMLoaderHelper;
import pt.digitalis.dif.dem.Entity;

/**
 * Holds the list of packages that will be searched for Entity classes by the DIFCodeGenerator. Provides methods to add
 * packages to the list of packages, and to access the list.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Jul 23, 2007
 */
final public class DEMRegistratorImpl implements IDEMRegistrator {

    /** The list of entities, by type, to exclude from the load process */
    private final Map<Entity, List<String>> entitiesToExclude = new HashMap<Entity, List<String>>();

    /**
     * @see pt.digitalis.dif.dem.config.IDEMRegistrator#excludeEntities(pt.digitalis.dif.dem.Entity, java.util.List)
     */
    public void excludeEntities(Entity entityType, List<String> entities)
    {
        List<String> result = getEntitiesToExclude(entityType);
        result.addAll(entities);

        this.entitiesToExclude.put(entityType, result);
    }

    /**
     * @see pt.digitalis.dif.dem.config.IDEMRegistrator#excludeEntity(pt.digitalis.dif.dem.Entity, java.lang.String)
     */
    public void excludeEntity(Entity entityType, String entity)
    {
        List<String> result = getEntitiesToExclude(entityType);
        result.add(entity);

        this.entitiesToExclude.put(entityType, result);
    }

    /**
     * @see pt.digitalis.dif.dem.config.IDEMRegistrator#getEntitiesToExclude(pt.digitalis.dif.dem.Entity)
     */
    public List<String> getEntitiesToExclude(Entity entityType)
    {
        List<String> result = this.entitiesToExclude.get(entityType);

        if (result == null)
        {
            result = new ArrayList<String>();
        }
        return result;
    }

    /**
     * @see pt.digitalis.dif.dem.config.IDEMRegistrator#registerAppSuiteBasePackage(java.lang.String)
     */
    public boolean registerAppSuiteBasePackage(String packageName)
    {
        return (DEMLoaderHelper.addPackage(packageName + "." + DEMLoaderHelper.PROVIDERS_DIR)
                && DEMLoaderHelper.addPackage(packageName + "." + DEMLoaderHelper.APPLICATIONS_DIR)
                && DEMLoaderHelper.addPackage(packageName + "." + DEMLoaderHelper.SERVICES_DIR)
                && DEMLoaderHelper.addPackage(packageName + "." + DEMLoaderHelper.STAGES_DIR) && DEMLoaderHelper
                    .addPackage(packageName + "." + DEMLoaderHelper.VALIDATORS_DIR));
    }

    /**
     * @see pt.digitalis.dif.dem.config.IDEMRegistrator#registerMetaModelPackage(java.lang.String)
     */
    public boolean registerMetaModelPackage(String packageName)
    {
        return (DEMLoaderHelper.addPackage(packageName));
    }
}
