/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.config;

import java.util.List;

import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.utils.annotations.Contribution;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Sep 20, 2007
 */
@Contribution
public interface IDEMRegistrator {

    /**
     * Exclude the list of entities to exclude from the load process
     * 
     * @param entityType
     *            the entity type
     * @param entities
     *            the list of entities to exclude
     */
    public void excludeEntities(Entity entityType, List<String> entities);

    /**
     * Exclude the entity to exclude from the load process
     * 
     * @param entityType
     *            the entity type
     * @param entity
     *            the list of entities to exclude
     */
    public void excludeEntity(Entity entityType, String entity);

    /**
     * Get the list of entities to be exclude from the DEM load process
     * 
     * @param entityType
     *            the entity type
     * @return the list of entities to be exclude
     */
    public List<String> getEntitiesToExclude(Entity entityType);

    /**
     * Adds a package to the folder list. This CodeGen utility will search a group of conventioned subpackages and none
     * other: providers, applications, services, stages, validators
     * 
     * @param packageName
     *            the package name
     * @return T if app suite was successfully added, F otherwise
     */
    public boolean registerAppSuiteBasePackage(String packageName);

    /**
     * Adds a package to the package list of classes to enrich. This CodeGen utility will search all subpackages inside
     * the given package for annotated entity classes
     * 
     * @param packageName
     *            the package name
     * @return T if package was successfully registered, F otherwise
     */
    public boolean registerMetaModelPackage(String packageName);

}
