/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.dem.annotations.parameter.FormConfigurable;
import pt.digitalis.dif.dem.annotations.parameter.Parameter;
import pt.digitalis.dif.dem.interfaces.ICustomFormDefinition;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.utils.common.collections.CaseInsentiveArrayList;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 28/01/2014
 */
public class CustomFormDefinition implements ICustomFormDefinition {

    /**
     * this specific configuration business ID. Is null this configuration is for all instances of the form (or the
     * default ones - this s business defined on a per usage basis)
     */
    private String businessConfigurationID;

    /**
     * List of parameter customizations as defined in the @{@link FormConfigurable} annotation in linkedToForm @
     * {@link Parameter} annotated class fields for given form
     */
    private Map<String, FormFieldCustomization> customizedParameters = new HashMap<String, FormFieldCustomization>();

    /**
     * List of excluded parameters as defined in the @{@link FormConfigurable} annotation in linkedToForm @
     * {@link Parameter} annotated class fields for given form
     */
    private List<String> excludedParameters = new CaseInsentiveArrayList();

    /** the stage's form name */
    private String formName;

    /** the stage ID */
    private String stageID;

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getBusinessConfigurationID()
     */
    public String getBusinessConfigurationID()
    {
        return businessConfigurationID;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getCustomizedParameters()
     */
    public Map<String, FormFieldCustomization> getCustomizedParameters()
    {
        return customizedParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getExcludedParameters()
     */
    public List<String> getExcludedParameters()
    {
        return excludedParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getFormName()
     */
    public String getFormName()
    {
        return formName;
    }

    /**
     * @see pt.digitalis.dif.dem.interfaces.ICustomFormDefinition#getStageID()
     */
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Modifier for the 'businessConfigurationID' attribute.
     * 
     * @param businessConfigurationID
     *            the new businessConfigurationID value to set
     */
    public void setBusinessConfigurationID(String businessConfigurationID)
    {
        this.businessConfigurationID = businessConfigurationID;
    }

    /**
     * Modifier for the 'customizedParameters' attribute.
     * 
     * @param customizedParameters
     *            the new customizedParameters value to set
     */
    public void setCustomizedParameters(Map<String, FormFieldCustomization> customizedParameters)
    {
        this.customizedParameters = customizedParameters;
    }

    /**
     * Modifier for the 'excludedParameters' attribute.
     * 
     * @param excludedParameters
     *            the new excludedParameters value to set
     */
    public void setExcludedParameters(CaseInsentiveArrayList excludedParameters)
    {
        this.excludedParameters = excludedParameters;
    }

    /**
     * Modifier for the 'formName' attribute.
     * 
     * @param formName
     *            the new formName value to set
     */
    public void setFormName(String formName)
    {
        this.formName = formName;
    }

    /**
     * Modifier for the 'stageID' attribute.
     * 
     * @param stageID
     *            the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("stageID", this.stageID);
        formatter.addItem("formName", this.formName);
        formatter.addItem("businessID", this.businessConfigurationID);
        formatter.addItem("excludedParameters", this.excludedParameters);
        formatter.addItem("customizedParameters", this.customizedParameters);

        return formatter.getFormatedObject();
    }
}
