/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.dif.dem.objects.messages;

import pt.digitalis.dif.utils.ObjectFormatter;


/**
 * Represents a message item.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Nov 2, 2007
 */
public class Message {

    /** The message */
    private String message;

    /** Customized message */
    private String customMessage;

    /**
     * Constructor
     * 
     * @param message
     *            the message
     * @param customMessage
     *            the customized message
     */
    public Message(String message, String customMessage) {
        this.message = message;
        this.customMessage = customMessage;
    }

    /**
     * Constructor
     * 
     * @param message
     *            the message
     */
    public Message(String message) {
        this(message, null);
    }

    /**
     * @return the Default Message
     */
    public String getDefaultMessage() {
        return message;
    }

    /**
     * @return the message
     */
    public String getMessage() {
        return (customMessage == null? message: customMessage);
    }
    
    /**
     * @return T if the message has been customized
     */
    public boolean isCustomized() {
        return (customMessage != null);
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        ObjectFormatter formatter = new ObjectFormatter();
        
        formatter.addItem("Message", message);
        formatter.addItemIfNotNull("Custom Message", customMessage);
        
        return formatter.getFormatedObject();
    }
}