/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters;

import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.managers.IParameterManager;
import pt.digitalis.dif.exception.objects.ParameterException;

import com.google.inject.Inject;

/**
 * {@link IParameters} default implementation
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 22, 2007
 */
public class ParametersImpl implements IParameters {

    /** Map of application parameter lists */
    private ParameterList applicationParameters = null;

    /** The message manager */
    @Inject
    IParameterManager manager;

    /** Map of provider parameter lists */
    private ParameterList providerParameters = null;

    /** Map of service parameter lists */
    private ParameterList serviceParameters = null;

    /** The stage to witch the parameters are associated */
    private IStageInstance stage;

    /** Map of stage parameter lists */
    private ParameterList stageParameters = null;

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#addStageParameter(java.lang.Class, java.lang.String,
     *      pt.digitalis.dif.dem.objects.parameters.ParameterScope, java.lang.String, java.lang.String)
     */
    public <T extends IParameter<?>> T addStageParameter(Class<T> parameterClass, String parameterID,
            ParameterScope parameterScope, String defaultValue, String constraintDefinition) throws ParameterException
    {
        T parameter;

        try
        {
            parameter = parameterClass.newInstance();
        }
        catch (InstantiationException e)
        {
            throw new ParameterException("Cannot create the parameter instance", e, null);
        }
        catch (IllegalAccessException e)
        {
            throw new ParameterException("Cannot create the parameter instance", e, null);
        }

        parameter.initialize(parameterID, Entity.STAGE, stage.getID(), false, false, false, parameterScope,
                defaultValue, constraintDefinition, null, null);

        this.getStageParameters().addParameter(parameter);

        return parameter;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#getAllAvailableParameters()
     */
    public ParameterList getAllAvailableParameters() throws ParameterException
    {
        ParameterList allParameters = new ParameterList();
        allParameters.addParameters(getProviderParameters());
        allParameters.addParameters(getApplicationParameters());
        allParameters.addParameters(getServiceParameters());
        allParameters.addParameters(getStageParameters());

        return allParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#getApplicationParameters()
     */
    public ParameterList getApplicationParameters() throws ParameterException
    {

        if (this.applicationParameters == null)
        {
            ParameterList parameterList = this.manager.getParameters(this.stage.getService().getApplication());

            try
            {
                this.applicationParameters = parameterList.cloneMe();
            }
            catch (CloneNotSupportedException e)
            {
                e.printStackTrace();
            }
        }
        return this.applicationParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#getProviderParameters()
     */
    public ParameterList getProviderParameters() throws ParameterException
    {
        if (this.providerParameters == null)
        {
            ParameterList parameterList = this.manager.getParameters(this.stage.getService().getApplication()
                    .getProvider());
            try
            {
                this.providerParameters = parameterList.cloneMe();
            }
            catch (CloneNotSupportedException e)
            {
                e.printStackTrace();
            }
        }
        return this.providerParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#getServiceParameters()
     */
    public ParameterList getServiceParameters() throws ParameterException
    {
        if (this.serviceParameters == null)
        {
            ParameterList parameterList = this.manager.getParameters(this.stage.getService());
            try
            {
                this.serviceParameters = parameterList.cloneMe();
            }
            catch (CloneNotSupportedException e)
            {
                e.printStackTrace();
            }
        }
        return this.serviceParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#getStageParameters()
     */
    public ParameterList getStageParameters() throws ParameterException
    {

        if (this.stageParameters == null)
        {
            ParameterList parameterList = this.manager.getParameters(this.stage);
            try
            {
                this.stageParameters = parameterList.cloneMe();
            }
            catch (CloneNotSupportedException e)
            {
                e.printStackTrace();
            }
        }

        return this.stageParameters;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.IParameters#initialize(pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    public void initialize(IStageInstance stage)
    {
        this.stage = stage;
    }
}
