/**
 * 
 */
package pt.digitalis.dif.dem.objects.parameters.validators;

import pt.digitalis.dif.controller.interfaces.IDIFContext;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 16, 2007
 * 
 */
public interface IParameterValidator {

	// TODO: Implement this feature

	/**
	 * Validates the given value
	 * 
	 * @param value
	 *            the value to validate
	 * @param context
	 *            the context
	 * @return T if the validation has passed
	 */
	public boolean validate(Object value, IDIFContext context);

    /**
     * Get a description on why the validation fails
     * 
     * @param language
     *            the language on witch to create the error message
     * @return the validation error message
     */
    public String validationErrorMessage(String language);

    /**
     * Get a description on why the validation fails
     * 
     * @return the validation error message in the default language
     */
    public String validationErrorMessage();
}
