/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.exception.controller;

import pt.digitalis.dif.controller.objects.ControllerExecutionStep;
import pt.digitalis.dif.exception.DIFException;
import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * Represents an exception occurred in the controller tasks (AbstractChAL or Dispatcher)
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 21, 2007
 */
public class ControllerException extends DIFException {

    /** Serial Version ID. */
    private static final long serialVersionUID = 1120934514453714926L;

    /** T if the controller exception was generated by another exception */
    private boolean generatedFromException = false;

    /** The controller execution step */
    private ControllerExecutionStep step;

    /**
     * Constructs a new ControllerException from an Exception.
     * 
     * @param exception
     *            the exception to encapsulate
     * @param step
     *            the execution step
     */
    public ControllerException(ControllerExecutionStep step, Exception exception)
    {
        super(exception);
        this.generatedFromException = true;
        this.step = step;
    }

    /**
     * Constructs a new ControllerException from a reason for the exception.
     * 
     * @param reason
     *            the exception cause
     * @param step
     *            the execution step
     */
    public ControllerException(ControllerExecutionStep step, String reason)
    {
        super(reason);
        this.step = step;
    }

    /**
     * Constructs a new ControllerException accepting a reason for the exception
     * 
     * @param reason
     *            the exception cause
     * @param exception
     *            the exception to encapsulate
     * @param step
     *            the execution step
     */
    public ControllerException(ControllerExecutionStep step, String reason, Exception exception)
    {
        super(reason, exception);
        this.generatedFromException = true;
        this.step = step;
    }

    /**
     * @see pt.digitalis.dif.exception.IContextException#getRenderedExceptionContext()
     */
    @Override
    public String getRenderedExceptionContext()
    {

        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItemIfNotNull("Step", step.toString());
        formatter.addItemIfNotNull("Cause", getCause());
        formatter.addItemIfNotNull("Message", getMessage());
        formatter.addItemIfNotNull("Exception Context", getExceptionContext());

        return "DIF Controller Exception:\n" + formatter.getFormatedObject() + "\n";
    }

    /**
     * @return the step
     */
    public ControllerExecutionStep getStep()
    {
        return step;
    }

    /**
     * @return the generatedFromException
     */
    public boolean isGeneratedFromException()
    {
        return generatedFromException;
    }
}
