package pt.digitalis.dif.exception.manager;

/**
 * Thrown when a requested LDAP operation does not succeed.
 * 
 * @author Joo Galaio <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 2008/04/02
 */
public class RegistrationManagerException extends Exception {

    /** The serial version ID. */
    private static final long serialVersionUID = -312327368449607144L;

    /**
     * Constructs a new exception with a message.
     * 
     * @param message
     *            the exception message
     */
    public RegistrationManagerException(String message)
    {
        super(message);
    }

    /**
     * Constructs a new exception with a message and a cause.
     * 
     * @param message
     *            the exception message
     * @param cause
     *            the exception cause
     */
    public RegistrationManagerException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Constructs a new exception with a cause.
     * 
     * @param cause
     *            the exception cause
     */
    public RegistrationManagerException(Throwable cause)
    {
        super(cause);
    }
}
