/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica.
 *
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.ioc;

import pt.digitalis.dif.controller.interfaces.INavigationHistory;
import pt.digitalis.dif.controller.objects.NavigationHistoryImpl;
import pt.digitalis.dif.controller.security.managers.ISessionManager;
import pt.digitalis.dif.controller.security.managers.impl.SessionManagerImpl;
import pt.digitalis.utils.ioc.modules.IIoCModule;
import pt.digitalis.utils.ioc.modules.IoCBinder;

/**
 * Contribution for parameter validation. Default constraints and validators
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 16, 2007
 *
 */
public class ControllerModule implements IIoCModule {

    /**
     * @see pt.digitalis.utils.ioc.modules.IIoCModule#configure(pt.digitalis.utils.ioc.modules.IoCBinder)
     */
    public void configure(IoCBinder binder) {

        // Session Management
        binder.bind(ISessionManager.class, SessionManagerImpl.class).asSingleton();
        binder.bind(INavigationHistory.class, NavigationHistoryImpl.class);
    }
}
