/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.startup;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * Configuration object for framework parameters.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Dec 12, 2007
 */
@ConfigID("dif2")
@ConfigSectionID("GeneralConfigurations")
public class DIFGeneralConfigurationParameters {

    /**
     * The singleton instance
     */
    static private DIFGeneralConfigurationParameters instance = null;

    /**
     * Returns the active configuration object instance.
     * 
     * @return the configuration instance
     */
    @ConfigIgnore
    static public DIFGeneralConfigurationParameters getInstance()
    {
        if (instance == null)
            try
            {
                instance = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class)
                        .readConfiguration(DIFGeneralConfigurationParameters.class);
            }
            catch (Exception e)
            {
                instance = null;
            }

        return instance;
    }

    /** The client name */
    private String client;

    /**
     * If the forms allow customizations saved in the persistence layer. Possible values: Y-Yes, N-No, D-Depends if the
     * 'dif-database-repository' is enabled
     */
    private String customForms;

    /** The default language for messages */
    private String defaultLanguage;

    /** T to enable monitorization by external apps like New Relic */
    private Boolean monitorizationEnabled;

    /**
     * If the pools persist their actions to database. Possible values: Y-Yes, N-No, D-Depends if the
     * 'dif-database-repository' is enabled
     */
    private String persistPools;

    /** The interval in seconds that DIF collects inactive sessions */
    private int secondsForSessionCleanup;

    /** Time after the session has timed out that the cleanup Collection will consider before purging the session (ms). */
    private long sessionExpirationTimeAfterTimeout;

    /** The session time out value (ms). */
    private long sessionTimeout;

    /**
     * Inspector for the 'client' attribute.
     * 
     * @return the client value
     */
    @ConfigDefault("")
    public String getClient()
    {
        return client;
    }

    /**
     * Inspector for the 'customForms' attribute.
     * 
     * @return the customForms value
     */
    @ConfigDefault("D")
    public String getCustomForms()
    {
        return customForms;
    }

    /**
     * Inspector for the default language property.
     * 
     * @return the default language value
     */
    @ConfigDefault("en")
    public String getDefaultLanguage()
    {
        return defaultLanguage;
    }

    /**
     * Inspector for the 'monitorizationEnabled' attribute.
     * 
     * @return the monitorizationEnabled value
     */
    @ConfigDefault("false")
    public Boolean getMonitorizationEnabled()
    {
        return monitorizationEnabled;
    }

    /**
     * Inspector for the 'persistPools' attribute.
     * 
     * @return the persistPools value
     */
    @ConfigDefault("D")
    public String getPersistPools()
    {
        return persistPools;
    }

    /**
     * Inspector for the session collection time property.
     * 
     * @return the session collection time property value
     */
    @ConfigDefault("1800")
    public int getSecondsForSessionCleanup()
    {
        return secondsForSessionCleanup;
    }

    /**
     * @return the sessionExpirationTimeAfterTimeout
     */
    public long getSessionExpirationTimeAfterTimeout()
    {
        return sessionExpirationTimeAfterTimeout;
    }

    /**
     * Returns the defined session time out value. Default value is 5 minutes.
     * 
     * @return the defined sessionTimeout value
     */
    @ConfigDefault("1800000")
    public long getSessionTimeout()
    {
        return this.sessionTimeout;
    }

    /**
     * Modifier for the 'client' attribute.
     * 
     * @param client
     *            the new client value to set
     */
    public void setClient(String client)
    {
        this.client = client;
    }

    /**
     * Modifier for the 'customForms' attribute.
     * 
     * @param customForms
     *            the new customForms value to set
     */
    public void setCustomForms(String customForms)
    {
        this.customForms = customForms;
    }

    /**
     * Modifier for the default language property.
     * 
     * @param defaultLanguage
     *            the new default language value to set
     */
    public void setDefaultLanguage(String defaultLanguage)
    {
        this.defaultLanguage = defaultLanguage.toLowerCase();
    }

    /**
     * Modifier for the 'monitorizationEnabled' attribute.
     * 
     * @param monitorizationEnabled
     *            the new monitorizationEnabled value to set
     */
    public void setMonitorizationEnabled(Boolean monitorizationEnabled)
    {
        this.monitorizationEnabled = monitorizationEnabled;
    }

    /**
     * Modifier for the 'persistPools' attribute.
     * 
     * @param persistPools
     *            the new persistPools value to set
     */
    public void setPersistPools(String persistPools)
    {
        this.persistPools = persistPools;
    }

    /**
     * Modifier for the session collection time property.
     * 
     * @param secondsForSessionCleanup
     *            the session collection time property value to set
     */
    public void setSecondsForSessionCleanup(int secondsForSessionCleanup)
    {
        this.secondsForSessionCleanup = secondsForSessionCleanup;
    }

    /**
     * @param sessionExpirationTimeAfterTimeout
     */
    public void setSessionExpirationTimeAfterTimeout(long sessionExpirationTimeAfterTimeout)
    {
        this.sessionExpirationTimeAfterTimeout = sessionExpirationTimeAfterTimeout;
    }

    /**
     * Sets the new session timeout value.
     * 
     * @param sessionTimeout
     *            the sessionTimeout to set
     */
    public void setSessionTimeout(long sessionTimeout)
    {
        this.sessionTimeout = sessionTimeout;
    }
}
