package pt.digitalis.dif.utils.logging;

import java.io.PrintWriter;
import java.io.StringWriter;

import pt.digitalis.dif.utils.mail.MailSender;
import pt.digitalis.dif.utils.mail.MailType;
import pt.digitalis.log.LogLevel;
import pt.digitalis.utils.common.StringUtils;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 16/04/2014
 */
public class ErrorLogManagerDIFLoggerImpl implements IErrorLogManager {

    /**
     * @see pt.digitalis.dif.utils.logging.IErrorLogManager#logError(java.lang.String, java.lang.String,
     *      java.lang.Exception)
     */
    public void logError(String applicationName, String processName, Exception e)
    {

        String errorMessage = "";
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        errorMessage += "Exception: " + errors.toString() + "\n";

        this.logError(applicationName, processName, errorMessage);
    }

    /**
     * @see pt.digitalis.dif.utils.logging.IErrorLogManager#logError(java.lang.String, java.lang.String,
     *      java.lang.String)
     */
    public void logError(String applicationName, String processName, String errorDescription)
    {

        DIFLogger.getLogger().error(
                "AplicationName: " + applicationName + " - ProcessName: " + processName + " - ErrorDescription: "
                        + errorDescription);

        if (!StringUtils.isBlank(LoggingConfiguration.getInstance().getErrorLogEmailAddress())
                && !StringUtils.isBlank(LoggingConfiguration.getInstance().getErrorLogEmailBody())
                && !StringUtils.isBlank(LoggingConfiguration.getInstance().getErrorLogEmailSubject()))
        {
            try
            {
                MailSender.getInstance().sendEmail(MailType.PLAIN_TEXT,
                        MailSender.getInstance().getConfiguration().getDefaultFromAddress(),
                        LoggingConfiguration.getInstance().getErrorLogEmailAddress(), null, null,
                        LoggingConfiguration.getInstance().getErrorLogEmailSubject(),
                        LoggingConfiguration.getInstance().getErrorLogEmailBody(), null, null, null, true);
            }
            catch (Exception e)
            {
                DIFLogger.getLogger().log(LogLevel.INFO, "Error sending Email in ErrorLogManager" + e);
            }
        }
    }
}
