/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.exception.controller.ControllerException;

/**
 * Defines the Authentication integrations API
 * 
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created Dec 14, 2010
 */
public interface IAuthenticationPlugin {

    /**
     * Executes the necessary action after a login is executed by the DIF Dispatcher Authentication step
     * 
     * @param context
     *            the current executing context
     */
    public void doAfterLogin(IDIFContext context);

    /**
     * Executes the necessary action after a logout is executed by the DIF Dispatcher Authentication step
     * 
     * @param context
     *            the current executing context
     */
    public void doAfterLogout(IDIFContext context);

    /**
     * Executes the necessary action before a login is executed by the DIF Dispatcher Authentication step
     * 
     * @param context
     *            the current executing context
     */
    public void doBeforeLogin(IDIFContext context);

    /**
     * Executes the necessary action before a logout is executed by the DIF Dispatcher Authentication step
     * 
     * @param context
     *            the current executing context
     */
    public void doBeforeLogout(IDIFContext context);

    /**
     * Executes the user validation
     * 
     * @param context
     *            the current executing context
     * @param user
     *            the user id
     * @param password
     *            the user password
     * @return <code>true</code> if the user is valid
     * @throws ControllerException
     *             the exception that prevents the authentication to be performed
     */
    public boolean validateUser(IDIFContext context, String user, String password) throws ControllerException;
}
