/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.interfaces;

/**
 * Defines a public accessible DIF Session
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 29, 2007
 */
public interface IPrivateDIFSession extends IDIFSession {

    /**
     * Touches the session so it remains active.
     */
    public void forceKeepAlive();

    /**
     * The criteria for a timed out session is that the last access time plus the session time out must be higher than
     * the current time.
     * 
     * @return T time after the session has timed out that the cleanup Collection will consider before purging the
     *         session (ms).
     */
    public boolean hasExpiredAfterTimeOut();

    /**
     * Touches the session so it remains active, if the session hasn't expired or is marked for removal.
     */
    public void keepAlive();

    /**
     * Marks the session to be removed
     * 
     * @param markedForRemoval
     */
    public void setMarkedForRemoval(Boolean markedForRemoval);
}
