/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.security.managers;

import java.util.Map;

import pt.digitalis.dif.controller.security.objects.IDIFGroup;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.exception.security.IdentityManagerException;

/**
 * Defines the expected behavior for an identity manager. This manager supports users {@link IDIFUser} and groups
 * {@link IDIFGroup}.
 * 
 * @author Rodrigo Gon�alves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Luis Pinto <a href="lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @author Fbio Souto <a href="mailto:fsouto@digitalis.pt">fsouto@digitalis.pt</a><br/>
 * @created 2007/12/04
 */
public interface IIdentityManagerPrivate extends IIdentityManager {

    /**
     * Persists an attribute value on a given user on the underlying repository.
     * 
     * @param userID
     *            the ID of the user to update
     * @param attributeID
     *            the ID of the attribute to update
     * @param attributeValue
     *            the value of the attribute to update
     * @throws IdentityManagerException
     *             if the attribute can't be updated
     */
    public void persistUserAttribute(String userID, String attributeID, Object attributeValue)
            throws IdentityManagerException;

    /**
     * Persists all attributes values on a given user on the underlying repository.
     * 
     * @param userID
     *            the ID of the user to update
     * @param attributes
     *            the attributes to update
     * @throws IdentityManagerException
     *             if the attribute can't be updated
     */
    public void persistUserAttributes(String userID, Map<String, Object> attributes) throws IdentityManagerException;

}
