/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica. 
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.dem.annotations;

/**
 * This class defines a set of tags that are reused on different DIF meta-model
 * Annotations.
 * 
 * @author Rodrigo Gonalves <a
 *         href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/10
 */
final public class AnnotationTags {

    /*
     * Implementation Note:
     * 
     * This type should really be an enumerated type, but since the tags must
     * be used as default values for annotation member values and JLS requires
     * these defaults to be constant and the enum spec does not guarantee this 
     * "constness" the type can't be an enumerated.
     */

    /**
     * Tag for code generation module that indicates that the ID must be
     * generated from the class name (lower case).
     */
    final static public String GENERATE_ID = "CGID:Must generate ID from lower-case class name";

    /** Definition of the default provider. */
    final static public String DEFAULT_PROVIDER = "CGID:Digitalis";

    /** Definition of the default channel. */
    final static public String DEFAULT_CHANNEL = "CGID:Web";

    /** Definition of the Parameter's default group visibility. */
    final static public String DEFAULT_GROUP_VISIBILTY = "CGID:Default Group Visibilty";

    /** Multipurpose for optional parameters that will have their value programmatically determined. */
    final static public String NONE = "CGID:Parameter ommited";
}
