/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica. 
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.dem.annotations.metaannotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a DEM Annotation as a primary annotation.
 * 
 * A primary annotation must be the only one of it's type to annotate an element
 * and excludes all the other primary annotations.
 * 
 * Primary annotations can have one of two types: <b>pure primary</b> and
 * <b>non-pure primary</b>. Non-pure primary annotations might be used as
 * non-primary annotations on some contexts. To define these contexts the
 * programmer must supply a list of annotations to whom the annotation yields
 * its primariness.
 * 
 * @author Pedro Viegas <a
 *         href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a
 *         href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Aug 29, 2007
 */
@Target(ElementType.ANNOTATION_TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Primary {
	/**
	 * The list of annotations that force the primariness yielding.
	 * 
	 * TODO: Should allow for simple class names, defaulting to the current
	 * package. Also allow the use of:
	 *  - "#BasePackage#.entities.ApplicationDefinition
	 *  - "#BasePackage#.Application
	 *  - "#Entities#.ApplicationDefinition
	 *  - "#Parameter#.Parameter
	 *  - "#Stage#.ErrorView
	 *
     * TO Rodrigo: see note on pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary#value()
	 */
    
	String yieldTo() default "Pure primary";
}
