/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica.
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 -
 * Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21
 * 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.stage;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.CallbackType;
import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

/**
 * This annotation marks a stage for session tracking. It can be used on POJOs annotated with
 * <code>@StageDefinition</code>.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/11
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary("pt.digitalis.dif.dem.annotations.entities.StageDefinition")
public @interface Callback {

    /** The callback type. Keep track without saving the session by default. */
    CallbackType value() default CallbackType.SIMPLE;
}
