/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects;

import pt.digitalis.dif.dem.objects.messages.Message;
import pt.digitalis.dif.dem.objects.messages.MessageList;
import pt.digitalis.dif.dem.objects.messages.MessageTranslations;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.utils.common.StringUtils;

/**
 * The customization of a form field
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 28/01/2014
 */
public class FormFieldCustomization {

    /** the configuration id to save the help message */
    public final static String MESSAGE_HELP_ID = "help";

    /** the configuration id to save the hint message */
    public final static String MESSAGE_HINT_ID = "hint";

    /** the configuration id to save the label message */
    public final static String MESSAGE_LABEL_ID = "label";

    /** the form field ID */
    private String fieldID;

    /** if the field is mandatory */
    private FeatureState mandatory = FeatureState.DEFAULT;

    /** the customized messages */
    private MessageList messages = null;

    /**
     * @param fieldID
     */
    public FormFieldCustomization(String fieldID)
    {
        this.fieldID = fieldID;
    }

    /**
     * Utility method that returns the desired customized message or the default one if no customization exists
     * 
     * @param messageID
     *            the message ID to get
     * @param language
     *            the desired language
     * @param defaultValue
     *            the default value of not custom message exists
     * @return the custom message or if it does not exist the given default value
     */
    public String getCustomMessage(String messageID, String language, String defaultValue)
    {
        MessageList messageList = this.getMessages();
        MessageTranslations messageTranslations = null;
        Message message = null;

        if (messageList != null)
            messageTranslations = messageList.getMessageTranslations(messageID);
        if (messageTranslations != null)
            message = messageTranslations.getTranslations().get(language);

        if (message != null && StringUtils.isNotBlank(message.getMessage()))
            return message.getMessage();
        else
            return defaultValue;
    }

    /**
     * Inspector for the 'fieldID' attribute.
     * 
     * @return the fieldID value
     */
    public String getFieldID()
    {
        return fieldID;
    }

    /**
     * Inspector for the 'mandatory' attribute.
     * 
     * @return the mandatory value
     */
    public FeatureState getMandatory()
    {
        return mandatory;
    }

    /**
     * Inspector for the 'messages' attribute.
     * 
     * @return the messages value
     */
    public MessageList getMessages()
    {
        return messages;
    }

    /**
     * Modifier for the 'fieldID' attribute.
     * 
     * @param fieldID
     *            the new fieldID value to set
     * @return the updated object
     */
    public FormFieldCustomization setFieldID(String fieldID)
    {
        this.fieldID = fieldID;

        return this;
    }

    /**
     * Modifier for the 'mandatory' attribute.
     * 
     * @param mandatory
     *            the new mandatory value to set
     * @return the updated object
     */
    public FormFieldCustomization setMandatory(FeatureState mandatory)
    {
        this.mandatory = mandatory;

        return this;
    }

    /**
     * Modifier for the 'messages' attribute.
     * 
     * @param messages
     *            the new messages value to set
     * @return the updated object
     */
    public FormFieldCustomization setMessages(MessageList messages)
    {
        this.messages = messages;

        return this;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("FieldID", this.fieldID);
        formatter.addItem("Mandatory", this.mandatory);
        formatter.addItem("Messages", this.messages);

        return formatter.getFormatedObject();
    }
}
