/**
 *
 */
package pt.digitalis.dif.dem.objects.parameters.constraints;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.IParameter;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public interface IParameterConstraint {

    /**
     * Configures the constraint. Optional. The maximum value for max, or maskString for mask.
     * 
     * @param configurationString
     */
    public void configureConstraint(String configurationString);

    /**
     * Builds a JavaScript boolean expression to check this constraint. Will assume there is a "value" variable with the
     * current parameter value in context to get the parameter value from.
     * 
     * @return the JS code to validate
     */
    public String getJavaScriptValidationCondition();

    /**
     * Get the Validation result, Validates the parameter value passed in it's native type
     * 
     * @param value
     *            the value to validate
     * @param stageInstance
     *            the current stage in execution
     * @return T if the validation succeded
     */
    public ParameterConstraintResult getValidationResult(Object value, IStageInstance stageInstance);

    /**
     * Checks if the parameter attribute is of a supported class for this constraint to be used
     * 
     * @param clazz
     *            the class of the attribute on witch the constraint has been applied
     * @return T is it is a supported class
     */
    public boolean isSupportedClass(Class<?> clazz);

    /**
     * Sets the parameter that called the constraint.
     *
     * @param param
     *            the new parameter
     */
    public void setParameter(IParameter<?> param);

    /**
     * Validates the parameter value passed in it's native type
     * 
     * @param value
     *            the value to validate
     * @param stageInstance
     *            the current stage in execution
     * @return T if the validation succeeded
     */
    public boolean validateConstraint(Object value, IStageInstance stageInstance);

    /**
     * Validates the parameter value passed as a String
     * 
     * @param value
     *            the value to validate
     * @param stageInstance
     *            the current stage in execution
     * @return T if the validation succeded
     */
    public boolean validateConstraint(String value, IStageInstance stageInstance);

    /**
     * Get a description on why the validation fails
     * 
     * @return the validation error message in the default language
     */
    public String validationErrorMessage();

    /**
     * Get a description on why the validation fails
     * 
     * @param parseValues
     *            if T will replace the current parameter value in the message. Otherwise return the untouched message
     *            for custom parsing
     * @return the validation error message in the default language
     */
    public String validationErrorMessage(boolean parseValues);

    /**
     * Get a description on why the validation fails
     * 
     * @param parseValues
     *            if T will replace the current parameter value in the message. Otherwise return the untouched message
     *            for custom parsing
     * @param language
     *            the language on witch to create the error message
     * @return the validation error message
     */
    public String validationErrorMessage(boolean parseValues, String language);

    /**
     * Get a description on why the validation fails
     * 
     * @param language
     *            the language on witch to create the error message
     * @return the validation error message
     */
    public String validationErrorMessage(String language);

}
