/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.rules;

import java.util.ArrayList;
import java.util.List;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.IParameter;
import pt.digitalis.dif.dem.objects.parameters.ParameterList;
import pt.digitalis.dif.dem.objects.parameters.types.AbstractParameter;
import pt.digitalis.dif.exception.objects.ParameterException;

/**
 * Exclusive parameter rule. Validates if the given parameter is not selected along with other exclusive fill parameter.
 * Only one can have a filled value.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @param <T>
 *            the parameter base type
 * @created Mar 31, 2009
 */
public class ParameterRuleExclusive<T> extends AbstractParameterRule<T> {

    /**
     * Gets the validation result for the present parameter
     * 
     * @param stage
     *            the current stage
     * @param value
     *            the value to validate
     * @param initializationInProgress
     *            T if called within the dif parameter initialization
     * @param parameter
     *            the parameter for validation
     * @return the validation rule validation result
     * @throws ParameterException
     *             if the parameter does not exist
     */
    public ParameterRuleResult getValidationResult(IStageInstance stage, T value, boolean initializationInProgress,
            AbstractParameter<T> parameter) throws ParameterException
    {
        List<IParameter<?>> filledParameters = new ArrayList<IParameter<?>>();

        if (value == null || getParameters() == null || getParameters().isEmpty())
            return new ParameterRuleResult(true);

        else
        {
            ParameterList list = stage.getParameters().getAllAvailableParameters();

            for (String parameterID: getParameters())
            {
                IParameter<?> param = null;
                try
                {
                    param = list.getParameter(parameterID);

                    if (param.getValue(stage.getContext()) != null)
                        filledParameters.add(param);
                }
                catch (ParameterException e)
                {
                    filledParameters.add(param);
                }

            }

            if (filledParameters.isEmpty())
                return new ParameterRuleResult(true);

            else
            {
                StringBuffer buffer = new StringBuffer();

                buffer.append(this.getMessages(stage).get("onlyOne") + ": ");
                buffer.append("\"" + getParameterName(stage, parameterID) + "\"");

                for (IParameter<?> filledParam: filledParameters)
                    buffer.append(", \"" + getParameterName(stage, filledParam.getId()) + "\"");

                return new ParameterRuleResult(buffer.toString());

            }
        }
    }
}
