/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.exception.security;

import pt.digitalis.dif.controller.objects.ControllerExecutionStep;
import pt.digitalis.dif.exception.controller.ControllerException;

/**
 * Is throwned when a file upload is attempted without the controlling session attribute set. Will generally represent a
 * hack on the system
 * 
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a><br/>
 * @created Mar 9, 2010
 */
public class IllegalFileUploadException extends ControllerException {

    /**  */
    private static final long serialVersionUID = 323905729986028913L;

    /**
     * Default constructor
     * 
     * @param step
     *            the step when the exception was throwned
     */
    public IllegalFileUploadException(ControllerExecutionStep step)
    {
        super(
                step,
                new Exception(
                        "Ilegal file upload operation.\nFollow the application's interfce when attempting to upload information."));
    }

}
