package pt.digitalis.dif.utils.mail;

import java.util.Properties;

import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.utils.config.ConfigurationsPreferencesImpl;
import pt.digitalis.utils.config.IConfigurations;
import pt.digitalis.utils.config.annotations.ConfigDefault;
import pt.digitalis.utils.config.annotations.ConfigID;
import pt.digitalis.utils.config.annotations.ConfigIgnore;
import pt.digitalis.utils.config.annotations.ConfigSectionID;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created May 24, 2012
 */
@ConfigID(MailConfiguration.CONFIG_ID)
@ConfigSectionID(MailConfiguration.CONFIG_SECTION_ID)
public class MailConfiguration implements IMailConfiguration {

    /** The Constant CONFIG_ID. */
    public static final String CONFIG_ID = "Digi Utils";

    /** The Constant CONFIG_SECTION_ID. */
    public static final String CONFIG_SECTION_ID = "mail";

    /** the singleton instance. */
    private static MailConfiguration instance = null;

    /**
     * @return {@link MailConfiguration}
     */
    @ConfigIgnore
    public static IMailConfiguration getInstance()
    {
        if (instance == null)
        {
            instance = new ConfigurationsPreferencesImpl().readConfiguration(MailConfiguration.class);
            instance.setOriginalConfs(instance.getConfigurations().readConfiguration(CONFIG_ID, CONFIG_SECTION_ID));
        }
        return instance;
    }

    /** The configuration manager instance. */
    private IConfigurations configurations;

    /** Determines if the debug is enabled. */
    private String debugEnabled;

    /** The default from ail address. */
    private String defaultFromAddress;

    /** The charater encoding */
    private String encoding;

    /** The Gab Between Mails */
    private int gapBetweenMails;

    /** The Limit Max Emails */
    private int limitMaxEmails;

    /** The Limit Time Interval */
    private int limitTimeInterval;

    /** The mail server. */
    private String mailServer;

    /** The mail server security password. */
    private String mailServerPassword;

    /** The mail server port. */
    private int mailServerPort;

    /** The mail server security username. */
    private String mailServerUsername;

    /** The original confs. */
    private Properties originalConfs = null;

    /** The use ssl. */
    private Boolean useSSL;

    /**
     * MailConfiguration Construtor
     */
    public MailConfiguration()
    {

    }

    /**
     * Gets the configurations.
     * 
     * @return the configurations
     */
    @ConfigIgnore
    public IConfigurations getConfigurations()
    {

        if (configurations == null)
            configurations = DIFIoCRegistry.getRegistry().getImplementation(IConfigurations.class);

        return configurations;
    }

    /**
     * Inspector for the 'debugEnabled' attribute.
     * 
     * @return the debugEnabled value
     */
    @ConfigDefault("false")
    public String getDebugEnabled()
    {
        return debugEnabled;
    }

    /**
     * Inspector for the 'defaultFromAddress' attribute.
     * 
     * @return the defaultFromAddress value
     */
    @ConfigDefault("no-reply@company.com")
    public String getDefaultFromAddress()
    {
        return defaultFromAddress;
    }

    /**
     * Inspector for the 'enconding' attribute.
     * 
     * @return the enconding value
     */
    @ConfigDefault("ISO-8859-1")
    public String getEncoding()
    {
        return encoding;
    }

    /**
     * Inspector for the 'GapBetweenMails' attribute.
     * 
     * @return the gapBetweenMails value
     */
    @ConfigDefault("0")
    public int getGapBetweenMails()
    {
        return gapBetweenMails;
    }

    /**
     * Inspector for the 'LimitMaxEmails' attribute.
     * 
     * @return the limitMaxEmails value
     */
    @ConfigDefault("0")
    public int getLimitMaxEmails()
    {
        return limitMaxEmails;
    }

    /**
     * Inspector for the 'LimitTimeInterval' attribute.
     * 
     * @return the limitTimeInterval value
     */
    @ConfigDefault("0")
    public int getLimitTimeInterval()
    {
        return limitTimeInterval;
    }

    /**
     * Inspector for the 'mailServer' attribute.
     * 
     * @return the mailServer value
     */
    @ConfigDefault("domino.digitalis.pt")
    public String getMailServer()
    {
        return mailServer;
    }

    /**
     * Inspector for the 'mailServerPassword' attribute.
     * 
     * @return the mailServerPassword value
     */
    public String getMailServerPassword()
    {
        return mailServerPassword;
    }

    /**
     * Inspector for the 'mailServerPort' attribute.
     * 
     * @return the mailServerPort value
     */
    public int getMailServerPort()
    {
        return mailServerPort;
    }

    /**
     * Inspector for the 'mailServerUsername' attribute.
     * 
     * @return the mailServerUsername value
     */
    public String getMailServerUsername()
    {
        return mailServerUsername;
    }

    /**
     * Inspector for the 'originalConfs' attribute.
     * 
     * @return the originalConfs value
     */
    @ConfigIgnore
    public Properties getOriginalConfs()
    {
        return originalConfs;
    }

    /**
     * Inspector for the 'useSSL' attribute.
     * 
     * @return the useSSL value
     */
    @ConfigDefault("false")
    public Boolean getUseSSL()
    {
        return useSSL;
    }

    /**
     * Modifier for the 'configurations' attribute.
     * 
     * @param configurations
     *            the new configurations value to set
     */
    public void setConfigurations(IConfigurations configurations)
    {
        this.configurations = configurations;
    }

    /**
     * Modifier for the 'debugEnabled' attribute.
     * 
     * @param debugEnabled
     *            the new debugEnabled value to set
     */
    public void setDebugEnabled(String debugEnabled)
    {
        this.debugEnabled = debugEnabled;
    }

    /**
     * Modifier for the 'defaultFromAddress' attribute.
     * 
     * @param defaultFromAddress
     *            the new defaultFromAddress value to set
     */
    public void setDefaultFromAddress(String defaultFromAddress)
    {
        this.defaultFromAddress = defaultFromAddress;
    }

    /**
     * Modifier for the 'enconding' attribute.
     * 
     * @param enconding
     *            the new enconding value to set
     */
    public void setEncoding(String enconding)
    {
        this.encoding = enconding;
    }

    /**
     * Modifier for the 'GapBetweenMails' attribute.
     * 
     * @param gapBetweenMails
     *            the new gapBetweenMails value to set
     */
    public void setGapBetweenMails(int gapBetweenMails)
    {
        this.gapBetweenMails = gapBetweenMails;
    }

    /**
     * Modifier for the 'LimitMaxEmails' attribute.
     * 
     * @param limitMaxEmails
     *            the new limitMaxEmails value to set
     */
    public void setLimitMaxEmails(int limitMaxEmails)
    {
        this.limitMaxEmails = limitMaxEmails;
    }

    /**
     * Modifier for the 'LimitTimeInterval' attribute.
     * 
     * @param limitTimeInterval
     *            the new limitTimeInterval value to set
     */
    public void setLimitTimeInterval(int limitTimeInterval)
    {
        this.limitTimeInterval = limitTimeInterval;
    }

    /**
     * Modifier for the 'mailServer' attribute.
     * 
     * @param mailServer
     *            the new mailServer value to set
     */
    public void setMailServer(String mailServer)
    {
        this.mailServer = mailServer;
    }

    /**
     * Modifier for the 'mailServerPassword' attribute.
     * 
     * @param mailServerPassword
     *            the new mailServerPassword value to set
     */
    public void setMailServerPassword(String mailServerPassword)
    {
        this.mailServerPassword = mailServerPassword;
    }

    /**
     * Modifier for the 'mailServerPort' attribute.
     * 
     * @param mailServerPort
     *            the new mailServerPort value to set
     */
    public void setMailServerPort(int mailServerPort)
    {
        this.mailServerPort = mailServerPort;
    }

    /**
     * Modifier for the 'mailServerUsername' attribute.
     * 
     * @param mailServerUsername
     *            the new mailServerUsername value to set
     */
    public void setMailServerUsername(String mailServerUsername)
    {
        this.mailServerUsername = mailServerUsername;
    }

    /**
     * Modifier for the 'originalConfs' attribute.
     * 
     * @param originalConfs
     *            the new originalConfs value to set
     */
    public void setOriginalConfs(Properties originalConfs)
    {
        this.originalConfs = originalConfs;
    }

    /**
     * Modifier for the 'useSSL' attribute.
     * 
     * @param useSSL
     *            the new useSSL value to set
     */
    public void setUseSSL(Boolean useSSL)
    {
        this.useSSL = useSSL;
    }

    /**
     * Write configuration
     * 
     * @throws Exception
     */
    public void writeConfiguration() throws Exception
    {
        this.getConfigurations().writeConfiguration(this);

    }
}
