package pt.digitalis.dif.utils.mail.sanitycheck;

import pt.digitalis.dif.sanitycheck.ExecutionResult;
import pt.digitalis.dif.sanitycheck.ISanityCheckTestSuite;
import pt.digitalis.dif.sanitycheck.TestResult;
import pt.digitalis.dif.sanitycheck.annotations.SanityCheckTest;
import pt.digitalis.dif.utils.mail.MailAction;
import pt.digitalis.dif.utils.mail.MailMemoryPool;
import pt.digitalis.dif.utils.mail.MailSender;
import pt.digitalis.dif.utils.mail.MailType;
import pt.digitalis.utils.pools.ActionStatus;

/**
 * @author Galaio da Silva <a href="mailto:jgalaio@digitalis.pt">jgalaio@digitalis.pt</a><br/>
 * @created 30 de Ago de 2011
 */
public class CheckMail implements ISanityCheckTestSuite {

    /**
     * Test the Mail configurations
     * 
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult test1MailConfiguration()
    {
        MailSender mailSender = MailSender.getInstance();

        String errorMessage = "";
        TestResult result = null;

        if (mailSender.getConfiguration().getMailServer() == null
                || "".equals(mailSender.getConfiguration().getMailServer()))
            errorMessage += "MailServer, ";

        if (mailSender.getConfiguration().getDefaultFromAddress() == null
                || "".equals(mailSender.getConfiguration().getDefaultFromAddress()))
            errorMessage += "DefaultFromAddress, ";

        if (!"".equals(errorMessage))
        {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
            errorMessage += " has configuration problems check in [CONFS]/Digi Utils/mail.";

            result = new TestResult(ExecutionResult.FAILED);
            result.setErrorMessage(errorMessage);
        }
        else
        {
            result = new TestResult(ExecutionResult.PASSED);
        }

        return result;
    }

    /**
     * Test the Mail authentication configurations
     * 
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult test2MailAuthenticationConfiguration()
    {
        MailSender mailSender = MailSender.getInstance();
        String errorMessage = "";
        TestResult result = null;

        if ("".equals(mailSender.getConfiguration().getMailServerUsername()))
            errorMessage += "MailServerUsername, ";

        if ("".equals(mailSender.getConfiguration().getMailServerPassword()))
            errorMessage += "MailServerPassword, ";

        if (!"".equals(errorMessage))
        {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 2);
            errorMessage += " with empty value. This could be a problem if you server has authentication or some restritions. If you don't need authenticantion bether keep #/Default/Value#. Check [CONFS]/Digi Utils/mail.";

            result = new TestResult(ExecutionResult.WARNING);
            result.setErrorMessage(errorMessage);
        }
        else
        {
            result = new TestResult(ExecutionResult.PASSED);
        }

        return result;
    }

    /**
     * Test send mail
     * 
     * @return <code>SanityUnitResult</code>
     */
    @SanityCheckTest
    public TestResult test3MailSend()
    {

        MailSender mailSender = MailSender.getInstance();
        String errorMessage = "";
        TestResult result = null;

        MailAction mailAction = new MailAction();
        mailAction.setSubject("Mail Sanity Check");
        mailAction.setMailSenderInstance(mailSender);
        mailAction.setAddressTo(mailSender.getConfiguration().getDefaultFromAddress());

        mailAction.setType(MailType.HTML);

        mailAction.setBody("Mail Sanity Check");
        mailAction = MailMemoryPool.getPool().executeActionWait(mailAction);

        if (mailAction.getStatus().equals(ActionStatus.FAILED))
            errorMessage += mailAction.getReason() + " | " + mailAction.getReasonException();

        if (!"".equals(errorMessage))
        {
            result = new TestResult(ExecutionResult.FAILED);
            result.setErrorMessage(errorMessage);
        }
        else
        {
            result = new TestResult(ExecutionResult.PASSED);
        }

        return result;

    }

}
