package pt.digitalis.dif.controller.interfaces;

import pt.digitalis.dif.controller.objects.DIFResponse;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;

/**
 * Defines a default interface for DIFDispatchers.
 * 
 * @see pt.digitalis.dif.controller.AbstractDIFDispatcher
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 11, 2007
 */
public interface IDIFDispatcher {

    /**
     * This method serves as an interface between the AbstractDIFDispatcher and the calling AbstractChAL. It is invoked by the AbstractChAL on a
     * AbstractDIFDispatcher object. The method verifies the request's integrity, generates the appropriate context and
     * schedules the request for service. When the execution is finished it returns the response to the AbstractChAL. If some
     * step on the execution flow doesn't happen as expected, an exception is raised.
     * 
     * @param difRequest
     *            The AbstractChAL-originated DIFRequest object
     * @return The response object to be delivered to the calling AbstractChAL
     * @throws BusinessFlowException
     *             when an exception is thrown by the stage's init/execute steps
     * @throws ControllerException
     *             when any runtime exception is thrown in a controller step
     */
    public abstract DIFResponse dispatch(IDIFRequest difRequest) throws BusinessFlowException, ControllerException;

    /**
     * @return the ID of the Channel this AbstractChAL manages
     */
    public String getChannelID();

}