/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.interfaces;

import java.util.Map;

import pt.digitalis.dif.controller.objects.ResultMessage;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.ViewObject;

/**
 * Defines the expected behavior for a DIF response.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a>
 * @created 2007/12/05
 */
public interface IDIFResponse {

    /**
     * Adds a HTTP header to response.
     * 
     * @param name
     *            the header name
     * @param value
     *            the header value
     */
    public void addHTTPHeader(String name, String value);

    /**
     * Adds an entry to the stage results map.
     * 
     * @param resultName
     *            the result name
     * @param resultValue
     *            the result value
     */
    public void addStageResult(String resultName, Object resultValue);

    /**
     * Get the HTTP Headers added before in a stage.
     * 
     * @return headers
     */
    public Map<String, String> getHTTPHeaders();

    /**
     * @return the request
     */
    public IDIFRequest getRequest();

    /**
     * Inspector for the 'resultMessage' attribute.
     * 
     * @return the resultMessage value
     */
    public ResultMessage getResultMessage();

    /**
     * @return the stageInstance
     */
    public IStageInstance getStageInstance();

    /**
     * Returns the value of the result with a given name, if it exists
     * 
     * @param resultName
     *            the result name
     * @return the value of the result with the supplied name, if it exists
     */
    public Object getStageResult(String resultName);

    /**
     * Returns the DIFResponse stage results.
     * 
     * @return The map with the stage results
     */
    public Map<String, Object> getStageResults();

    /**
     * ViewObject inspector.
     * 
     * @return the theView
     */
    public ViewObject getView();

    /**
     * Set the HTTP Headers
     * 
     * @param httpHeadersMap
     *            the HTTP Headers
     */
    public void setHTTPHeaders(Map<String, String> httpHeadersMap);

    /**
     * @param request
     *            the request to set
     */
    public void setRequest(IDIFRequest request);

    /**
     * Modifier for the 'resultMessage' attribute.
     * 
     * @param resultMessage
     *            the new resultMessage value to set
     */
    public void setResultMessage(ResultMessage resultMessage);

    /**
     * @param stageInstance
     *            the stageInstance to set
     */
    public void setStageInstance(IStageInstance stageInstance);

    /**
     * Builds the DIFResponse stage results based on an external map.
     * 
     * @param map
     *            The map with the original stage results
     */
    public void setStageResults(Map<String, Object> map);

    /**
     * ViewObject modifier.
     * 
     * @param newView
     *            the theView to set
     */
    public void setView(ViewObject newView);
}
