/**
 * 2008, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.objects;

import java.util.Date;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * A single item in a navigation history, representing stage item
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created 2008/07/20
 */
public class Breadcrumb {

    /** The session as it existed when the access took place */
    private IDIFSession difSession;

    /** the list of parsed parameters of the current stage */
    private String parameterPassed;

    /** The stage ID that was accessed */
    private String stageID;

    /** The timestamp of the stage access */
    private Date timestamp;

    /**
     * @param stageID
     */
    public Breadcrumb(String stageID)
    {
        this.stageID = stageID;
        this.timestamp = new Date();
    }

    /**
     * Inspector for the 'difSession' attribute.
     * 
     * @return the difSession value
     */
    public IDIFSession getDifSession()
    {
        return difSession;
    }

    /**
     * Inspector for the 'parameterPassed' attribute.
     * 
     * @return the parameterPassed value
     */
    public String getParameterPassed()
    {
        return parameterPassed;
    }

    /**
     * Inspector for the 'stageID' attribute.
     * 
     * @return the stageID value
     */
    public String getStageID()
    {
        return stageID;
    }

    /**
     * Inspector for the 'timestamp' attribute.
     * 
     * @return the timestamp value
     */
    public Date getTimestamp()
    {
        return timestamp;
    }

    /**
     * @return T if parameters are present
     */
    public boolean hasParameters()
    {
        return (parameterPassed != null && !"".equals(parameterPassed));
    }

    /**
     * Inspector that validates if the present breadcrumb has a session snapshot
     * 
     * @return T id session is saved
     */
    public boolean hasSessionSnapshot()
    {
        return (difSession != null);
    }

    /**
     * Modifier for the 'difSession' attribute.
     * 
     * @param difSession
     *            the new difSession value to set
     */
    public void setDifSession(IDIFSession difSession)
    {
        this.difSession = difSession;
    }

    /**
     * Modifier for the 'parameterPassed' attribute.
     * 
     * @param parameterPassed
     *            the new parameterPassed value to set
     */
    public void setParameterPassed(String parameterPassed)
    {
        this.parameterPassed = parameterPassed;
    }

    /**
     * Modifier for the 'stageID' attribute.
     * 
     * @param stageID
     *            the new stageID value to set
     */
    public void setStageID(String stageID)
    {
        this.stageID = stageID;
    }

    /**
     * Modifier for the 'timestamp' attribute.
     * 
     * @param timestamp
     *            the new timestamp value to set
     */
    public void setTimestamp(Date timestamp)
    {
        this.timestamp = timestamp;
    }

    /**
     * Returns the Request object in a human-readable form.
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("StageID", stageID);
        formatter.addItem("Parameters", parameterPassed);
        formatter.addItem("Timestamp", timestamp);
        formatter.addItem("Session", difSession);

        return formatter.getFormatedObject();
    }
}
