/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * Request client descriptor. It can be a browser, a SMS provider, a web service, a portal, etc...
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Nov 29, 2007
 */
public class ClientDescriptor {

    /** The attributes/configuration list of the client */
    private Map<String, Object> attributes = new HashMap<String, Object>();

    /** The list of languages supported by the client. */
    private List<String> clientSupportedLanguages = new ArrayList<String>();

    /** The feature list of the client */
    private Map<String, Object> features = new HashMap<String, Object>();

    /** The hardware of the client */
    private String hardware;

    /** The name of the Client */
    private String name;

    /** The software of the client */
    private String software;

    /** The client browser is supported */
    private Boolean supportedBrowser;

    /** The name of the software vendor */
    private String vendor;

    /** The version of the software of the client */
    private String version;

    /**
     * Adds a new attribute
     * 
     * @param key
     *            the attribute key
     * @param value
     *            the attribute value
     */
    public void addAttribute(String key, Object value)
    {
        this.attributes.put(key, value);
    }

    /**
     * Adds a new client supported language.
     * 
     * @param language
     *            the new supported language
     */
    public void addClientSupportedLanguage(String language)
    {
        this.clientSupportedLanguages.add(language);
    }

    /**
     * Adds a new feature
     * 
     * @param key
     *            the feature key
     * @param value
     *            the feature value
     */
    public void addFeature(String key, Object value)
    {
        this.features.put(key, value);
    }

    /**
     * Gets an attribute
     * 
     * @param key
     *            the attribute key
     * @return the object if existent
     */
    public Object getAttribute(String key)
    {
        return this.attributes.get(key);
    }

    /**
     * @return the attributes
     */
    public Map<String, Object> getAttributes()
    {
        return attributes;
    }

    /**
     * Returns the list of client supported languages.
     * 
     * @return the list of client supported languages
     */
    public List<String> getClientSupportedLanguages()
    {
        return this.clientSupportedLanguages;
    }

    /**
     * Gets an feature
     * 
     * @param key
     *            the feature key
     * @return the object if existent
     */
    public Object getFeature(String key)
    {
        return this.features.get(key);
    }

    /**
     * @return the features
     */
    public Map<String, Object> getFeatures()
    {
        return features;
    }

    /**
     * @return the hardware
     */
    public String getHardware()
    {
        return hardware;
    }

    /**
     * @return the name
     */
    public String getName()
    {
        return name;
    }

    /**
     * @return the software
     */
    public String getSoftware()
    {
        return software;
    }

    /**
     * @return the supportedBrowser
     */
    public Boolean getSupportedBrowser()
    {
        return supportedBrowser;
    }

    /**
     * @return the vendor
     */
    public String getVendor()
    {
        return vendor;
    }

    /**
     * @return the version
     */
    public String getVersion()
    {
        return version;
    }

    /**
     * Checks if a given language is supported by the client.
     * 
     * @param language
     *            the language to check
     * @return T if the language is supported, F otherwise
     */
    public boolean isLanguageSupported(String language)
    {
        return this.clientSupportedLanguages.contains(language);
    }

    /**
     * Removes a client supported language.
     * 
     * @param language
     *            the language to remove
     */
    public void removeClientSupportedLanguage(String language)
    {
        this.clientSupportedLanguages.remove(language);
    }

    /**
     * @param attributes
     *            the attributes to set
     */
    public void setAttributes(Map<String, Object> attributes)
    {
        this.attributes = attributes;
    }

    /**
     * Adds a new list of client supported language.
     * 
     * @param supportedLanguages
     *            the new supported language
     */
    public void setClientSupportedLanguages(List<String> supportedLanguages)
    {
        this.clientSupportedLanguages = supportedLanguages;
    }

    /**
     * @param features
     *            the features to set
     */
    public void setFeatures(Map<String, Object> features)
    {
        this.features = features;
    }

    /**
     * @param hardware
     *            the hardware to set
     */
    public void setHardware(String hardware)
    {
        this.hardware = hardware;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @param software
     *            the software to set
     */
    public void setSoftware(String software)
    {
        this.software = software;
    }

    /**
     * @param supportedBrowser
     */
    public void setSupportedBrowser(Boolean supportedBrowser)
    {
        this.supportedBrowser = supportedBrowser;
    }

    /**
     * @param vendor
     *            the vendor to set
     */
    public void setVendor(String vendor)
    {
        this.vendor = vendor;
    }

    /**
     * @param version
     *            the version to set
     */
    public void setVersion(String version)
    {
        this.version = version;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();

        formatter.addItem("Name", getName());
        formatter.addItemIfNotNull("software", software);
        formatter.addItemIfNotNull("version", version);
        formatter.addItemIfNotNull("hardware", hardware);

        formatter.addItemIfNotNull("Features", features);
        formatter.addItemIfNotNull("Attributes", attributes);

        return formatter.getFormatedObject();
    }
}
