/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import java.util.HashMap;
import java.util.Map;

import pt.digitalis.dif.controller.interfaces.IDIFRequest;
import pt.digitalis.dif.controller.interfaces.IDIFResponse;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * Implementation for {@link IDIFResponse}.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @author Luis Pinto <a href="mailto:lpinto@digitalis.pt">lpinto@digitalis.pt</a>
 * @created 2007/03/16
 */
public class DIFResponse implements IDIFResponse {

    /** Aditional headers we can put on response. This headers will prevail over the headers already added in framework */
    private Map<String, String> httpHeaders = new HashMap<String, String>();

    /** the originating request */
    private IDIFRequest request = null;

    /** the stage result message, if any */
    private ResultMessage resultMessage = null;

    /** the executed stage instance */
    private IStageInstance stageInstance = null;

    /** The processing result set. */
    private Map<String, Object> stageResults = new HashMap<String, Object>();

    /**
     * the ViewObject Object
     */
    private ViewObject theView = null;

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#addHTTPHeader(java.lang.String, java.lang.String)
     */
    public void addHTTPHeader(String name, String value)
    {
        this.httpHeaders.put(name, value);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#addStageResult(String, Object)
     */
    public void addStageResult(String resultName, Object resultValue)
    {
        this.stageResults.put(resultName, resultValue);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getHTTPHeaders()
     */
    public Map<String, String> getHTTPHeaders()
    {
        return this.httpHeaders;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getRequest()
     */
    public IDIFRequest getRequest()
    {
        return request;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getResultMessage()
     */
    public ResultMessage getResultMessage()
    {
        return resultMessage;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getStageInstance()
     */
    public IStageInstance getStageInstance()
    {
        return stageInstance;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getStageResult(String)
     */
    public Object getStageResult(String resultName)
    {
        return this.stageResults.get(resultName);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getStageResults()
     */
    public Map<String, Object> getStageResults()
    {
        return this.stageResults;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#getView()
     */
    public ViewObject getView()
    {
        return theView;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setHTTPHeaders(java.util.Map)
     */
    public void setHTTPHeaders(Map<String, String> httpHeadersMap)
    {
        httpHeaders.putAll(httpHeadersMap);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setRequest(pt.digitalis.dif.controller.interfaces.IDIFRequest)
     */
    public void setRequest(IDIFRequest request)
    {
        this.request = request;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setResultMessage(pt.digitalis.dif.controller.objects.ResultMessage)
     */
    public void setResultMessage(ResultMessage resultMessage)
    {
        this.resultMessage = resultMessage;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setStageInstance(pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    public void setStageInstance(IStageInstance stageInstance)
    {
        this.stageInstance = stageInstance;
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setStageResults(Map)
     */
    public void setStageResults(Map<String, Object> map)
    {
        stageResults.putAll(map);
    }

    /**
     * @see pt.digitalis.dif.controller.interfaces.IDIFResponse#setView(ViewObject)
     */
    public void setView(ViewObject newView)
    {
        this.theView = newView;
    }

    /**
     * Prints the Response in a human-readable form. Overrides java.lang.Object#toString().
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();
        formatter.addItem("View", theView);
        formatter.addItem("Stage Results", stageResults);

        return formatter.getFormatedObject();
    }
}
