/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.controller.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.controller.security.objects.IDIFGroup;
import pt.digitalis.dif.controller.security.objects.IDIFInternalUser;
import pt.digitalis.dif.controller.security.objects.IDIFUser;
import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IStage;
import pt.digitalis.dif.exception.InternalFrameworkException;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.utils.ObjectFormatter;
import pt.digitalis.utils.common.collections.CaseInsensitiveHashMap;

/**
 * Represents a IDIFUser in session after a successful login. This class contains a IDIFUser and the password that was
 * used by the user to login
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gon�alves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created Mar 25, 2008
 */
public class DIFUserInSession implements IDIFInternalUser {

    /** User attributes to remove. */
    private List<String> attributesToRemove = new ArrayList<String>();

    /** Is "default user"? */
    private boolean isDefault;

    /** the password used to login */
    private String password;

    /** The real user that was obtained from the {@link IIdentityManager} */
    private IDIFUser user;

    /**
     * @param user
     *            the IDIFUser
     * @param password
     *            the password used to login
     */
    public DIFUserInSession(IDIFUser user, String password)
    {
        this.user = user;
        this.password = password;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#addTempGroup(java.lang.String)
     */
    public void addTempGroup(String groupId)
    {
        user.addTempGroup(groupId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IUserAuthorization#canAccess(pt.digitalis.dif.dem.Entity,
     *      java.lang.String)
     */
    public boolean canAccess(Entity resourceType, String resourceId)
    {
        return user.canAccess(resourceType, resourceId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IUserAuthorization#canAccess(pt.digitalis.dif.dem.interfaces.IStage)
     */
    public boolean canAccess(IStage stage)
    {
        return user.canAccess(stage);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#cleanCache()
     */
    public void cleanCache()
    {
        user.cleanCache();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#containsAttribute(java.lang.String)
     */
    public boolean containsAttribute(String id)
    {
        return user.containsAttribute(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#containsParameter(java.lang.String)
     */
    public boolean containsParameter(String id)
    {
        return user.containsParameter(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getAttribute(java.lang.String)
     */
    public Object getAttribute(String id)
    {
        return user.getAttribute(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getAttributes()
     */
    public CaseInsensitiveHashMap<Object> getAttributes()
    {
        return user.getAttributes();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getAttributesToRemove()
     */
    public List<String> getAttributesToRemove()
    {
        return attributesToRemove;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getEmail()
     */
    public String getEmail()
    {
        return user.getEmail();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getGroupIDs()
     */
    public Set<String> getGroupIDs() throws IdentityManagerException
    {
        return user.getGroupIDs();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getGroups()
     */
    public Map<String, IDIFGroup> getGroups() throws IdentityManagerException
    {
        return user.getGroups();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getID()
     */
    public String getID()
    {
        return user.getID();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getName()
     */
    public String getName()
    {
        return user.getName();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getNick()
     */
    public String getNick()
    {
        return user.getNick();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getParameter(java.lang.String)
     */
    public Object getParameter(String id)
    {
        return user.getParameter(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getParameters()
     */
    public Map<String, Object> getParameters()
    {
        return user.getParameters();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFInternalUser#getPassword()
     */
    public String getPassword()
    {
        return this.password;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getProfile()
     */
    public IDIFGroup getProfile() throws IdentityManagerException
    {
        return user.getProfile();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#getProfileID()
     */
    public String getProfileID() throws IdentityManagerException
    {
        return user.getProfileID();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#initializeAttributes(java.util.Map)
     */
    public void initializeAttributes(Map<String, Object> attrs)
    {
        user.initializeAttributes(attrs);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#isDefault()
     */
    public boolean isDefault()
    {
        return this.isDefault;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#isEnabled()
     */
    public boolean isEnabled()
    {
        return user.isEnabled();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#refresh()
     */
    public void refresh()
    {
        user.refresh();
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeAttribute(java.lang.String)
     */
    public void removeAttribute(String id)
    {
        user.removeAttribute(id);
        attributesToRemove.add(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeParameter(java.lang.String)
     */
    public void removeParameter(String id)
    {
        user.removeParameter(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#removeTempGroup(java.lang.String)
     */
    public void removeTempGroup(String groupId)
    {
        user.removeTempGroup(groupId);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setAttribute(java.lang.String, java.lang.Object)
     */
    public void setAttribute(String id, Object attribute) throws InternalFrameworkException
    {
        user.setAttribute(id, attribute);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setAttributes(java.util.Map)
     */
    public void setAttributes(Map<String, Object> attributes) throws InternalFrameworkException
    {
        this.user.setAttributes(attributes);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setDefault(boolean)
     */
    public void setDefault(boolean isDefault)
    {
        this.isDefault = isDefault;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setEmail(java.lang.String)
     */
    public void setEmail(String email)
    {
        user.setEmail(email);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setEnabled(boolean)
     */
    public void setEnabled(boolean enabled)
    {
        user.setEnabled(enabled);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setID(java.lang.String)
     */
    public void setID(String id)
    {
        user.setID(id);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setName(java.lang.String)
     */
    public void setName(String name)
    {
        user.setName(name);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setNick(java.lang.String)
     */
    public void setNick(String nick)
    {
        user.setNick(nick);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setParameter(java.lang.String, java.lang.Object)
     */
    public void setParameter(String id, Object parameter)
    {
        user.setParameter(id, parameter);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setParameters(java.util.Map)
     */
    public void setParameters(Map<String, Object> parameters)
    {
        this.user.setParameters(parameters);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setPassword(java.lang.String)
     */
    public void setPassword(String password)
    {
        user.setPassword(password);
        this.password = password;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFUser#setProfileID(java.lang.String)
     */
    public void setProfileID(String profileGroupID)
    {
        user.setProfileID(profileGroupID);
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();

        formatter.addItem("ID", getID());
        formatter.addItemIfNotNull("Name", getName());
        formatter.addItemIfNotNull("Password", "*****");
        formatter.addItemIfNotNull("Nick", getNick());
        formatter.addItemIfNotNull("Email", getEmail());
        formatter.addItem("Enabled", isEnabled());
        formatter.addItemIfNotNull("Attributes", this.getAttributes());
        formatter.addItemIfNotNull("Parameters", this.getParameters());

        try
        {
            IDIFGroup profile = getProfile();
            formatter.addItem("Profile", profile);
        }
        catch (IdentityManagerException identityManagerException)
        {
            throw new RuntimeException("Could not access the user's profile on the identity manager!",
                    identityManagerException);
        }

        try
        {
            Map<String, IDIFGroup> groups = getGroups();
            formatter.addItemIfNotNull("Groups", groups);
        }
        catch (IdentityManagerException identityManagerException)
        {
            throw new RuntimeException("Could not access the user's groups on the identity manager!",
                    identityManagerException);
        }

        return formatter.getFormatedObject();
    }
}
