/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.objects;

/**
 * Defines a DiF exception handler
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/05/04
 */
public class ExceptionHandlerData {

    /** the exception class */
    private Class<Throwable> exceptionClass;

    /** The handler stage ID */
    private String handlerStageID;

    /**
     * @param exceptionClass
     * @param handlerStageID
     */
    public ExceptionHandlerData(Class<Throwable> exceptionClass, String handlerStageID)
    {
        this.exceptionClass = exceptionClass;
        this.handlerStageID = handlerStageID;
    }

    /**
     * Inspector for the 'exceptionClass' attribute.
     * 
     * @return the exceptionClass value
     */
    public Class<Throwable> getExceptionClass()
    {
        return exceptionClass;
    }

    /**
     * Inspector for the 'handlerStageID' attribute.
     * 
     * @return the handlerStageID value
     */
    public String getHandlerStageID()
    {
        return handlerStageID;
    }

    /**
     * Modifier for the 'exceptionClass' attribute.
     * 
     * @param exceptionClass
     *            the new exceptionClass value to set
     */
    public void setExceptionClass(Class<Throwable> exceptionClass)
    {
        this.exceptionClass = exceptionClass;
    }

    /**
     * Modifier for the 'handlerStageID' attribute.
     * 
     * @param handlerStageID
     *            the new handlerStageID value to set
     */
    public void setHandlerStageID(String handlerStageID)
    {
        this.handlerStageID = handlerStageID;
    }
}
