/**
 * 2009, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.objects;

/**
 * Result message type for all stages. Will contain erros, warns and other messages that we wish to convey to the user
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Nov 4, 2009
 */
public class ResultMessage {

    /** the detailed body of the message */
    private String description;

    /** The mode. */
    private String mode;

    /** if T will show the message in a popup dialog */
    private boolean popupMode;

    /** if T will require the user to confirm the message */
    private boolean requireConfirm = false;

    /** the title of the message */
    private String title;

    /** the type of the message */
    private String type;

    /**
     * Constructor.
     * 
     * @param type
     *            the type
     * @param title
     *            the title
     * @param description
     *            the description
     * @param popupMode
     *            the popup mode
     * @param requireConfirm
     * @param mode
     *            the mode
     */
    public ResultMessage(String type, String title, String description, boolean popupMode, boolean requireConfirm,
            String mode)
    {
        this.type = type;
        this.title = title;
        this.description = description;
        this.popupMode = popupMode;
        this.mode = mode;
        this.requireConfirm = requireConfirm;
    }

    /**
     * Constructor.
     * 
     * @param type
     *            the type
     * @param title
     *            the title
     * @param description
     *            the description
     * @param popupMode
     *            the popup mode
     * @param mode
     *            the mode
     */
    public ResultMessage(String type, String title, String description, boolean popupMode, String mode)
    {
        this.type = type;
        this.title = title;
        this.description = description;
        this.popupMode = popupMode;
        this.mode = mode;
        this.requireConfirm = false;
    }

    /**
     * Inspector for the 'description' attribute.
     * 
     * @return the description value
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * Inspector for the 'mode' attribute.
     * 
     * @return the mode value
     */
    public String getMode()
    {
        return mode;
    }

    /**
     * Inspector for the 'title' attribute.
     * 
     * @return the title value
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * Inspector for the 'type' attribute.
     * 
     * @return the type value
     */
    public String getType()
    {
        return type;
    }

    /**
     * Inspector for the 'popupMode' attribute.
     * 
     * @return the popupMode value
     */
    public boolean isPopupMode()
    {
        return popupMode;
    }

    /**
     * Inspector for the 'requireConfirm' attribute.
     * 
     * @return the requireConfirm value
     */
    public boolean isRequireConfirm()
    {
        return requireConfirm;
    }

    /**
     * Modifier for the 'description' attribute.
     * 
     * @param description
     *            the new description value to set
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * Modifier for the 'mode' attribute.
     * 
     * @param mode
     *            the new mode value to set
     */
    public void setMode(String mode)
    {
        this.mode = mode;
    }

    /**
     * Modifier for the 'popupMode' attribute.
     * 
     * @param popupMode
     *            the new popupMode value to set
     */
    public void setPopupMode(boolean popupMode)
    {
        this.popupMode = popupMode;
    }

    /**
     * Modifier for the 'requireConfirm' attribute.
     * 
     * @param requireConfirm
     *            the new requireConfirm value to set
     */
    public void setRequireConfirm(boolean requireConfirm)
    {
        this.requireConfirm = requireConfirm;
    }

    /**
     * Modifier for the 'title' attribute.
     * 
     * @param title
     *            the new title value to set
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * Modifier for the 'type' attribute.
     * 
     * @param type
     *            the new type value to set
     */
    public void setType(String type)
    {
        this.type = type;
    }
}
