/**
 * 2015, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.security.managers;

import pt.digitalis.dif.controller.interfaces.IDIFSession;
import pt.digitalis.dif.exception.security.AuthenticationManagerException;

/**
 * Defines private internal behaviour that we do not wish to expose to the normal API developers use
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 09/09/2015
 */
public interface ISessionManagerInternal {

    /**
     * Performs the log in of a user with a given id on the framework. This differs from the {@link ISessionManager}
     * .logIn method in not requiring a password.<br/>
     * It will simply place an existing user as authenticated without validating it's pasword in the
     * {@link IIdentityManager}'s database.
     * 
     * @param sessionID
     *            the session identifier
     * @param userID
     *            the id of the user to log in
     * @param password
     *            the password for the user
     * @return the updated session object
     * @throws AuthenticationManagerException
     *             if the authentication manager can't be accessed to validate the user's credentials
     */
    public IDIFSession logInNoPasswordValidation(String sessionID, String userID, String password)
            throws AuthenticationManagerException;
}
