/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.controller.security.objects;

import java.util.Map;
import java.util.Set;

import pt.digitalis.dif.controller.security.managers.IIdentityManager;
import pt.digitalis.dif.exception.security.IdentityManagerException;
import pt.digitalis.dif.ioc.DIFIoCRegistry;
import pt.digitalis.dif.utils.ObjectFormatter;

/**
 * Default implementation for DIF group.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/12/04
 */
public class DIFGroupImpl implements IDIFGroup {

    /** The identity manager implementation */
    static private IIdentityManager identityManager = DIFIoCRegistry.getRegistry().getImplementation(
            IIdentityManager.class);

    /** The group description. */
    private String groupDescription;

    /** The group id. */
    private String groupID;

    /** The group name. */
    private String groupName;

    /** Is "default group"? */
    private boolean isDefault;

    /** The parent group. */
    private String parentGroup;

    /**
     * Default constructor.
     */
    public DIFGroupImpl()
    {}

    /**
     * Creates a new group based on a given one
     * 
     * @param group
     *            the group to copy data from
     */
    public DIFGroupImpl(IDIFGroup group)
    {
        this.groupID = group.getID();
        this.groupName = group.getName();
        this.groupDescription = group.getDescription();
        this.parentGroup = group.getParentGroupID();
    }

    /**
     * @see java.lang.Object#clone()
     */
    @Override
    protected Object clone() throws CloneNotSupportedException
    {
        return new DIFGroupImpl(this);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#cloneGroup()
     */
    public IDIFGroup cloneGroup()
    {
        try
        {
            return (IDIFGroup) this.clone();
        }
        catch (CloneNotSupportedException e)
        {
            return null;
        }
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DIFGroupImpl other = (DIFGroupImpl) obj;
        if (groupID == null)
        {
            if (other.groupID != null)
                return false;
        }
        else if (!groupID.equals(other.groupID))
            return false;
        return true;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getDescription() */
    public String getDescription()
    {
        return this.groupDescription;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getID() */
    public String getID()
    {
        return this.groupID;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getName() */
    public String getName()
    {
        return this.groupName;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getParentGroup()
     */
    public IDIFGroup getParentGroup() throws IdentityManagerException
    {
        return DIFGroupImpl.identityManager.getGroup(this.getParentGroupID());
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getParentGroupID() */
    public String getParentGroupID()
    {
        return this.parentGroup;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getUserIDs()
     */
    public Set<String> getUserIDs() throws IdentityManagerException
    {
        return identityManager.getUserIDsInGroup(groupID);
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#getUsers()
     */
    public Map<String, IDIFUser> getUsers() throws IdentityManagerException
    {
        return identityManager.getGroupUsers(groupID);
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode()
    {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((groupID == null) ? 0 : groupID.hashCode());
        return result;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#isDefault()
     */
    public boolean isDefault()
    {
        return this.isDefault;
    }

    /**
     * @see pt.digitalis.dif.controller.security.objects.IDIFGroup#setDefault(boolean)
     */
    public void setDefault(boolean isDefault)
    {
        this.isDefault = isDefault;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#setDescription(String) */
    public void setDescription(String newDescription)
    {
        this.groupDescription = newDescription;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#setID(String) */
    public void setID(String newGroupId)
    {
        this.groupID = newGroupId;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#setName(String) */
    public void setName(String newName)
    {
        this.groupName = newName;
    }

    /** @see pt.digitalis.dif.controller.security.objects.IDIFGroup#setParentGroupID(String) */
    public void setParentGroupID(String newParent)
    {
        this.parentGroup = newParent;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        ObjectFormatter formatter = new ObjectFormatter();

        formatter.addItem("ID", getID());
        formatter.addItemIfNotNull("Name", getName());
        formatter.addItemIfNotNull("Description", getDescription());
        formatter.addItemIfNotNull("Parent Group", getParentGroupID());

        return formatter.getFormatedObject();
    }
}