/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica. 
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.dem.annotations.metaannotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Defines the list of primary annotations that accept the current annotation.
 * 
 * This meta-annotation is mandatory on non-primary annotations.
 * 
 * @author Pedro Viegas <a
 *         href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a
 *         href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Aug 29, 2007
 */
@Target(ElementType.ANNOTATION_TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface BindToPrimary {

	/**
	 * The FQN's of the annotations that can be used with the non-primary
	 * annotation.
	 * 
	 * TODO: Should allow for simple class names, defaulting to the current
	 * package. Also allow the use of:
	 *  - "#BasePackage#.entities.ApplicationDefinition
	 *  - "#BasePackage#.Application
	 *  - "#Entities#.ApplicationDefinition
	 *  - "#Parameter#.Parameter
	 *  - "#Stage#.ErrorView
     *  
     *  Algorithm (TO Rodrigo, BY Rodrigo): 
     *  
     *  On DEM Annotation's discovery:
     *  
     *  1) read the package of the the annotation annotated by this meta-annotation (Class.getPackage().getName()??)
     *  2) rewrite this member value's with the read package name concatenated with the member value
     *  
     *  Use an helper method since it's also present on <code>@ExclusiveWith</code> 
	 */
	String[] value();
}
