/**
 * - Digitalis Internal Framework v2.0 - (C) 2014, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.parameter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.Primary;

/**
 * Declares a method that can add/remove or change the stage's declared parameters, before their processing takes place.
 * It must be used on Stages only.<br/>
 * There should be <b>no value attribution</b> in the method since this is executed in the definition phase of the
 * stage. Parameter value initialization should be handled in the @Init or @Execute handlers as usual for the remaining
 * parameters.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 07/02/2014
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Primary
public @interface CustomParameters {
}
