/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.parameter;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

/**
 * This annotation defines a meta-model element parameter. It can be used on fields already annotated with the
 * {@link Parameter} annotation, of classes that are POJOs annotated with any of the following:
 * <code>@ProviderDefinition</code>, <code>@ApplicationDefinition</code>, <code>@ServiceDefinition</code>,
 * <code>@StageDefinition</code>.<br/>
 * <br/>
 * Can only be used with linkedToForm parameters
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 28/01/2014
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary("pt.digitalis.dif.dem.annotations.parameter.Parameter")
public @interface FormConfigurable {
}
