/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica.
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 -
 * Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21
 * 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.annotations.security;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

/**
 * This annotation defines a default Group for the containing DEM entity. The annotation can be used on the following
 * elements: <code>@ApplicationDefinition</code>.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Dec 6, 2007
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary( { "pt.digitalis.dif.dem.annotations.entities.ApplicationDefinition" })
public @interface Group {

    /** group name */
    String groupName();

    /** the group full name */
    String fullName() default "";

    /** parent group name */
    String groupParent() default "";
}
