/**
 * - Digitalis Internal Framework v2.0 -
 *
 * (C) 2007, Digitalis Informatica. 
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.dem.annotations.stage;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;
import pt.digitalis.dif.dem.annotations.metaannotations.ExclusiveWith;
import pt.digitalis.dif.dem.annotations.metaannotations.Primary;

/**
 * This annotation defines a stage for execution if an exception is thrown.
 * 
 * It is a non-pure primary annotation. Yields primariness to
 * <code>@StageDefinition</code> when used with this annotation.
 * 
 * @author Rodrigo Gonalves <a
 *         href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/05/11
 */
@Target({ElementType.TYPE, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
@Primary(yieldTo="pt.digitalis.dif.dem.annotations.entities.StageDefinition, pt.digitalis.dif.dem.annotations.stage.View")
@BindToPrimary("pt.digitalis.dif.dem.annotations.entities.StageDefinition")
@ExclusiveWith("pt.digitalis.dif.dem.annotations.stage.ErrorView")
public @interface ErrorStage {
    /** The error stage id. Mandatory field!! */
    String target();

    /**
     * The type of the exception whose raising will trigger the error stage. By
     * default, any Exception will trigger the error stage.
     */
    String exceptions() default "java.lang.exception";

}
