/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */

package pt.digitalis.dif.dem.annotations.stage.controller;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import pt.digitalis.dif.dem.annotations.metaannotations.BindToPrimary;

/**
 * This annotation allows the programmer to configure the Stage execution by the DIF dispatcher. Using this annotation
 * the programmer can specify if the Stage will enable authentication or if it will require authorization prior to
 * running.
 * 
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a><br/>
 * @created 2007/12/05
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@BindToPrimary("pt.digitalis.dif.dem.annotations.entities.StageDefinition")
public @interface DispatcherMode {

    /** Enable authentication. */
    boolean authenticate() default true;

    /** Enable authorization. */
    boolean authorize() default true;
}
