/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica.
 * Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos num.9 -
 * Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21
 * 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.interfaces;

/**
 * This interface exposes the behavior related to a DEM Registry.
 * <p>
 * It presents methods to retrieve providers, applications, services and stages
 * based on IDs.
 */
public interface IDEMRegistry {

    /**
     * Returns a provider associated with a given ID.
     * 
     * @param providerID
     *            the provider ID
     * @return the provider associated with the given ID if the ID is valid,
     *         null otherwise
     */
    public IProvider getProvider(String providerID);

    /**
     * Returns an application associated with a given ID.
     * 
     * @param applicationID
     *            the application ID
     * @return the provider associated with the given ID if the ID is valid,
     *         null otherwise
     */
    public IApplication getApplication(String applicationID);

    /**
     * Returns a service associated with a given ID.
     * 
     * @param serviceID
     *            the service ID
     * @return the service associated with the given ID if the ID is valid, null
     *         otherwise
     */
    public IService getService(String serviceID);

    /**
     * Returns a stage associated with a given ID.
     * 
     * @param stageID
     *            the stage ID
     * @return the stage associated with the given ID if the ID is valid, null
     *         otherwise
     */
    public IStage getStage(String stageID);
}
