/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.interfaces;

import pt.digitalis.dif.controller.interfaces.IDIFContext;
import pt.digitalis.dif.dem.objects.EventType;
import pt.digitalis.dif.dem.objects.ViewObject;
import pt.digitalis.dif.dem.objects.parameters.errors.ParameterErrors;
import pt.digitalis.dif.exception.controller.BusinessFlowException;
import pt.digitalis.dif.exception.controller.ControllerException;

/**
 * This interface represents a Stage entity on the DEM.
 * <p>
 * A Stage is related to a Service.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created 2007/07/12
 */
public interface IStageInstance extends IStage, IMessage {

    /**
     * The business logic executing method.
     * <p>
     * This method should define the Stage business logic.
     * 
     * @param context
     *            the execution context
     * @return a view
     * @throws BusinessFlowException
     *             when an exception is thrown by the stage's init/execute steps
     */
    public ViewObject _CG_execute(IDIFContext context) throws BusinessFlowException;

    /**
     * The finalization method.
     * <p>
     * This method should perform any tasks related to the Stage initialization.
     * <p>
     * Not to be confused with Java's own <code>protected void finalize() throws Throwable</code>.
     * 
     * @param context
     *            the execution context
     * @return T if finalization was successful, F otherwise
     * @throws BusinessFlowException
     *             when an exception is thrown by the stage's init/execute steps
     */
    public boolean _CG_finalize(IDIFContext context) throws BusinessFlowException;

    /**
     * The initialization method.
     * <p>
     * This method should perform any tasks related to the Stage initialization.
     * 
     * @param context
     *            the execution context
     * @return T if initialization went ok, F otherwise
     * @throws BusinessFlowException
     *             when an exception is thrown by the stage's init/execute steps
     */
    public boolean _CG_init(IDIFContext context) throws BusinessFlowException;

    /**
     * The method that will be enhanced with the call to the correct event method.
     * 
     * @param context
     *            the execution context
     * @param type
     *            the type of the fired event
     * @param eventName
     *            the name of the event
     * @return the object to return
     */
    public Object callEventMethod(IDIFContext context, EventType type, String eventName);

    /**
     * The method that will be enhanced with the call to the method annotated with <code>@Execute</code>.
     * 
     * @param context
     *            the execution context
     * @return the view to return
     */
    public ViewObject callExecuteMethod(IDIFContext context);

    /**
     * The method that will be enhanced with the call to the method annotated with <code>@Execute</code>.
     * 
     * @param context
     *            the execution context
     * @param type
     *            the type of the fired event
     * @param eventName
     *            the name of the event
     * @return the view to return
     */
    public ViewObject callExecuteOnEventMethod(IDIFContext context, EventType type, String eventName);

    /**
     * Declares for the current stage instance that a given feature is enabled
     * 
     * @param featureID
     *            the feature Id to declare active
     */
    public void declareFeatureActive(String featureID);

    /**
     * Gets the authentication error after an initialization has occurred
     * 
     * @return the controller error exception object
     */
    public ControllerException getAuthenticationError();

    /**
     * Returns the execution context.
     * 
     * @return the execution context
     */
    public IDIFContext getContext();

    /**
     * Gets the parameter errors after a initialization has occurred
     * 
     * @return the parameter errors object
     */
    public ParameterErrors getParameterErrors();

    /**
     * Validates if a given feature is active/present
     * 
     * @param featureID
     *            the Id of the feature do validate is is present/active
     * @return true if it is active/present
     */
    public boolean isFeatureEnabled(String featureID);

    /**
     * @return T if the stage has already been initialized by calling the "_CG_init" method
     */
    public boolean isInitialized();

    /**
     * Sets the authentication error
     * 
     * @param exception
     *            the authentication exception
     */
    public void setAuthenticationError(ControllerException exception);

    /**
     * Sets the execution context on the Stage.
     * 
     * @param context
     *            the execution context
     */
    public void setContext(IDIFContext context);

    /**
     * Sets the parameter errors
     * 
     * @param errors
     *            the errors object to set
     */
    public void setParameterErrors(ParameterErrors errors);

    /**
     * Sets the associated proxy to call info upon
     * 
     * @param proxy
     *            the proxy to set
     */
    public void setProxy(IStage proxy);
}
