/**
 * - Digitalis Internal Framework v2.0 - (C) 2007, Digitalis Informatica. Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999
 * http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.managers;

import java.util.Map;

import pt.digitalis.dif.dem.Entity;
import pt.digitalis.dif.dem.interfaces.IApplication;
import pt.digitalis.dif.dem.interfaces.IEntity;
import pt.digitalis.dif.dem.interfaces.IProvider;
import pt.digitalis.dif.dem.interfaces.IService;
import pt.digitalis.dif.dem.interfaces.IStage;

/**
 * This interface manages the DEM entities, providing the connections between the elements to the CodeGen module.
 *
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @author Rodrigo Gonalves <a href="mailto:rgoncalves@digitalis.pt">rgoncalves@digitalis.pt</a>
 * @created Oct 3, 2007
 */
public interface IDEMManager {

    /**
     * Returns all applications related to the given provider.
     *
     * @param provider
     *            the provider
     * @return a map of all applications associated with the provider
     */
    public Map<String, IApplication> getApplications(IProvider provider);

    /**
     * Returns all services related to the given application.
     *
     * @param application
     *            the application
     * @return a map of all services associated with the application
     */
    public Map<String, IService> getServices(IApplication application);

    /**
     * Returns all stages related to the given service.
     *
     * @param service
     *            the service
     * @return a map with all the stages related to the service
     */
    public Map<String, IStage> getStages(IService service);

    /**
     * Returns all registered providers.
     *
     * @return a map with all the registered providers.
     */
    public Map<String, IProvider> getProviders();

    /**
     * Returns the provider with the given id
     *
     * @param providerID
     *            the provider id
     * @return the provider
     */
    public IProvider getProvider(String providerID);

    /**
     * Returns the application with the given id
     *
     * @param applicationID
     *            the application id
     * @return the application
     */
    public IApplication getApplication(String applicationID);

    /**
     * Returns the service with the given id
     *
     * @param serviceID
     *            the service id
     * @return the service
     */
    public IService getService(String serviceID);

    /**
     * Returns the stage with the given id
     *
     * @param stageID
     *            the stage id
     * @return the stage
     */
    public IStage getStage(String stageID);

    /**
     * Returns the entity with the given id
     *
     * @param type
     *            the entity type
     * @param entityID
     *            the entity ID
     * @return the entity object
     */
    public IEntity getEntity(Entity type, String entityID);

    /**
     * Returns the default provider
     *
     * @return the provider
     */
    public IProvider getDefaultProvider();
}
