/**
 * 2014, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.managers.impl;

import pt.digitalis.dif.controller.http.HTTPConstants;
import pt.digitalis.dif.dem.interfaces.ICustomFormDefinition;
import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.managers.ICustomFormManager;
import pt.digitalis.dif.dem.objects.CustomFormDefinition;
import pt.digitalis.utils.common.StringUtils;

/**
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 29/01/2014
 */
public class CustomFormManagerDummyImpl implements ICustomFormManager {

    /**
     * @see pt.digitalis.dif.dem.managers.ICustomFormManager#getConfiguration(pt.digitalis.dif.dem.interfaces.IStageInstance,
     *      java.lang.String)
     */
    public final ICustomFormDefinition getConfiguration(IStageInstance stageInstance, String businessConfigurationID)
    {
        Object submitStage = stageInstance.getContext().getRequest().getParameter(HTTPConstants.FORM_SUBMIT_STAGE);
        Object submitForm = stageInstance.getContext().getRequest().getParameter(HTTPConstants.FORM_SUBMIT_NAME);

        return this.getConfiguration(StringUtils.toStringOrNull(submitStage), StringUtils.toStringOrNull(submitForm),
                businessConfigurationID);
    }

    /**
     * @see pt.digitalis.dif.dem.managers.ICustomFormManager#getConfiguration(java.lang.String, java.lang.String,
     *      java.lang.String)
     */
    public ICustomFormDefinition getConfiguration(String stageID, String formName, String businessConfigurationID)
    {
        CustomFormDefinition def = new CustomFormDefinition();
        def.setStageID(stageID.toLowerCase());
        def.setFormName(formName.toLowerCase());
        def.setBusinessConfigurationID(businessConfigurationID);

        return def;
    }

    /**
     * @see pt.digitalis.dif.dem.managers.ICustomFormManager#updateConfiguration(pt.digitalis.dif.dem.interfaces.ICustomFormDefinition)
     */
    public void updateConfiguration(ICustomFormDefinition definition)
    {
        // In this dummy implementation there is nothing to do. will only be relevant for persistent implementations
    }

}
