/** 2007, Digitalis Informatica. All rights reserved.
 * 
 * Distribuicao e Gestao de Informatica, Lda.
 * Estrada de Paco de Arcos num.9 - Piso -1
 * 2780-666 Paco de Arcos
 * Telefone: (351) 21 4408990
 * Fax: (351) 21 4408999
 * http://www.digitalis.pt 
 */
package pt.digitalis.dif.dem.objects.parameters;

/**
 * Parameter persistence scopes
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created Nov 2, 2007
 */
public enum ParameterScope {

    /**
     * Parameter value will persist only during the request execution and for the current session. Much like an class
     * instance attribute.
     */
    REQUEST,

    /**
     * Parameter value will persist while the JVM is up. It's value will be shared among sessions. Much like a class
     * static attribute.
     */
    STATIC,

    /** Parameter value will persist during the current session of the current user. */
    SESSION,

    /**
     * Parameter value will persist between sessions for the current user. A session parameter common to all session of
     * the same user. Kept in the JVM, not in the persistent repository
     */
    USER;
}
