/**
 * 2007, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */
package pt.digitalis.dif.dem.objects.parameters.constraints.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint;

/**
 * Max parameter constraint implementation
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a>
 * @created Nov 16, 2007
 */
public class ParameterConstraintMaxSizeImpl extends AbstractParameterConstraint {

    /** Supported classes by numeric constraints */
    @SuppressWarnings("serial")
    final static private List<String> supportedClasses = new ArrayList<String>() {

        {
            add(String.class.getCanonicalName());
        }
    };

    /** Last tested value */
    String lastTestedValue;

    /** Max size to validate */
    Integer maxSize;

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#configureConstraint(java.lang.String)
     */
    public void configureConstraint(String configurationString)
    {

        String value = configurationString.substring(configurationString.indexOf("=") + 1);

        maxSize = new Integer(value.trim());
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.AbstractParameterConstraint#getErrorMessageValues(boolean)
     */
    @Override
    protected Map<String, String> getErrorMessageValues(boolean parseValues)
    {
        Map<String, String> substitutions = new HashMap<String, String>();

        if (parseValues)
        {
            substitutions.put("value", lastTestedValue);
        }
        substitutions.put("max", maxSize.toString());

        return substitutions;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#getJavaScriptValidationCondition()
     */
    public String getJavaScriptValidationCondition()
    {
        return "(new String(value).length <= " + maxSize + ")";
    }

    /**
     * Inspector for the 'maxSize' attribute.
     * 
     * @return the maxSize value
     */
    public Integer getMaxSize()
    {
        return maxSize;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#isSupportedClass(java.lang.Class)
     */
    public boolean isSupportedClass(Class<?> clazz)
    {
        return supportedClasses.contains(clazz.getCanonicalName());
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.IParameterConstraint#validateConstraint(java.lang.String,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    public boolean validateConstraint(String value, IStageInstance stageInstance)
    {
        lastTestedValue = value;

        return (value == null || value.length() <= maxSize);
    }
}
