/**
 * 2010, Digitalis Informatica. All rights reserved. Distribuicao e Gestao de Informatica, Lda. Estrada de Paco de Arcos
 * num.9 - Piso -1 2780-666 Paco de Arcos Telefone: (351) 21 4408990 Fax: (351) 21 4408999 http://www.digitalis.pt
 */

package pt.digitalis.dif.dem.objects.parameters.constraints.impl.date;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import pt.digitalis.dif.dem.interfaces.IStageInstance;
import pt.digitalis.utils.common.DateUtils;

/**
 * Date in Past parameter constraint implementation.<br>
 * Will validate if the given date is in the past as it is mandatory.
 * 
 * @author Pedro Viegas <a href="mailto:pviegas@digitalis.pt">pviegas@digitalis.pt</a><br/>
 * @created 2010/09/14
 */
public class ParameterConstraintDateInPastImpl extends ParameterConstraintDateImpl {

    /**
     * @param value
     *            the date to see if it's in the past
     * @return T if the given date is not after the current one
     */
    private boolean isDateInPast(Date value)
    {
        Calendar calendarValue = Calendar.getInstance();
        calendarValue.setTime(value);

        return !Calendar.getInstance().before(calendarValue);
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateImpl#validateConstraint(java.lang.Object,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public boolean validateConstraint(Object value, IStageInstance stageInstance)
    {
        if (value == null)
            return true;
        else if (value instanceof Date)
        {
            lastTestedValue = DateUtils.simpleDateToString((Date) value);

            return isDateInPast((Date) value);
        }
        else if (value instanceof String)
            return this.validateConstraint(value.toString(), stageInstance);
        else
            return false;
    }

    /**
     * @see pt.digitalis.dif.dem.objects.parameters.constraints.impl.date.ParameterConstraintDateImpl#validateConstraint(java.lang.String,
     *      pt.digitalis.dif.dem.interfaces.IStageInstance)
     */
    @Override
    public boolean validateConstraint(String value, IStageInstance stageInstance)
    {
        if (super.validateConstraint(value, stageInstance))
        {
            try
            {
                return isDateInPast(DateUtils.stringToSimpleDate(value));
            }
            catch (ParseException e)
            {
                return false;
            }
        }
        else
            return false;
    }
}
